/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.configuration.ConfigValues;

public class ConfigGroups {
    public static Function<ConfigValues, List<Configuration>> groups(String baseName) {
        Pattern pattern = Pattern.compile(Pattern.quote(baseName) + "\\.(\\d+)\\.(.+)");
        return values -> {
            HashMap<String, HashMap<String, String>> groups = new HashMap<String, HashMap<String, String>>();
            for (Pair<String, String> entry : values.rawConfiguration()) {
                Matcher matcher = pattern.matcher((CharSequence)entry.first());
                if (!matcher.matches()) continue;
                String index = matcher.group(1);
                String configName = matcher.group(2);
                String value = (String)entry.other();
                HashMap<String, String> groupConfig = (HashMap<String, String>)groups.get(index);
                if (groupConfig == null) {
                    groupConfig = new HashMap<String, String>();
                    groups.put(index, groupConfig);
                }
                groupConfig.put(configName, value);
            }
            Function<Map, Configuration> mapper = m -> new Configuration((Map)m){
                final /* synthetic */ Map val$m;
                {
                    this.val$m = map;
                }

                public <T> T get(Setting<T> setting) {
                    return (T)setting.apply(this.val$m::get);
                }
            };
            return groups.values().stream().map(mapper).collect(Collectors.toList());
        };
    }
}

