/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.factory;

import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.security.URLAccessRule;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.configuration.Settings;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.factory.ClassicCoreSPI;
import org.neo4j.kernel.impl.factory.DataSourceModule;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.Edition;
import org.neo4j.kernel.impl.factory.EditionModule;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.impl.query.QueryEngineProvider;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.Logger;

public class GraphDatabaseFacadeFactory {
    protected final DatabaseInfo databaseInfo;
    private final Function<PlatformModule, EditionModule> editionFactory;

    public GraphDatabaseFacadeFactory(DatabaseInfo databaseInfo, Function<PlatformModule, EditionModule> editionFactory) {
        this.databaseInfo = databaseInfo;
        this.editionFactory = editionFactory;
    }

    public GraphDatabaseFacade newFacade(File storeDir, Map<String, String> params, Dependencies dependencies) {
        return this.initFacade(storeDir, params, dependencies, new GraphDatabaseFacade());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public GraphDatabaseFacade initFacade(File storeDir, Map<String, String> params, final Dependencies dependencies, GraphDatabaseFacade graphDatabaseFacade) {
        platform = this.createPlatform(storeDir, params, dependencies, graphDatabaseFacade);
        edition = this.editionFactory.apply(platform);
        queryEngine = new AtomicReference<QueryExecutionEngine>(QueryEngineProvider.noEngine());
        dataSource = this.createDataSource(platform, edition, (Supplier<QueryExecutionEngine>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, get(), ()Lorg/neo4j/kernel/impl/query/QueryExecutionEngine;)(queryEngine));
        msgLog = platform.logging.getInternalLog(this.getClass()).infoLogger();
        coreAPIAvailabilityGuard = edition.coreAPIAvailabilityGuard;
        spi = new ClassicCoreSPI(platform, dataSource, msgLog, coreAPIAvailabilityGuard);
        graphDatabaseFacade.init(spi, dataSource.guard, dataSource.threadToTransactionBridge, platform.config);
        platform.dataSourceManager.addListener(new DataSourceManager.Listener(){
            private QueryExecutionEngine engine;

            @Override
            public void registered(NeoStoreDataSource dataSource) {
                if (this.engine == null) {
                    this.engine = QueryEngineProvider.initialize(platform.dependencies, platform.graphDatabaseFacade, dependencies.executionEngines());
                }
                queryEngine.set(this.engine);
            }

            @Override
            public void unregistered(NeoStoreDataSource dataSource) {
                queryEngine.set(QueryEngineProvider.noEngine());
            }
        });
        error = null;
        try {
            this.enableAvailabilityLogging(platform.availabilityGuard, msgLog);
            platform.life.start();
            ** if (error == null) goto lbl-1000
        }
        catch (Throwable throwable) {
            try {
                error = new RuntimeException("Error starting " + this.getClass().getName() + ", " + platform.storeDir, throwable);
                ** if (error == null) goto lbl-1000
            }
            catch (Throwable var14_16) {
                if (error != null) {
                    try {
                        graphDatabaseFacade.shutdown();
                    }
                    catch (Throwable shutdownError) {
                        error = Exceptions.withSuppressed(shutdownError, new Throwable[]{error});
                    }
                }
                throw var14_16;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    graphDatabaseFacade.shutdown();
                }
                catch (Throwable shutdownError) {
                    error = Exceptions.withSuppressed(shutdownError, new Throwable[]{error});
                }
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            try {
                graphDatabaseFacade.shutdown();
            }
            catch (Throwable shutdownError) {
                error = Exceptions.withSuppressed(shutdownError, new Throwable[]{error});
            }
        }
lbl-1000:
        // 2 sources

        {
        }
        if (error != null) {
            msgLog.log("Failed to start database", error);
            throw Exceptions.launderedException(error);
        }
        return graphDatabaseFacade;
    }

    protected PlatformModule createPlatform(File storeDir, Map<String, String> params, Dependencies dependencies, GraphDatabaseFacade graphDatabaseFacade) {
        return new PlatformModule(storeDir, params, this.databaseInfo, dependencies, graphDatabaseFacade);
    }

    protected DataSourceModule createDataSource(PlatformModule platformModule, EditionModule editionModule, Supplier<QueryExecutionEngine> queryEngine) {
        return new DataSourceModule(platformModule, editionModule, queryEngine);
    }

    private void enableAvailabilityLogging(AvailabilityGuard availabilityGuard, final Logger msgLog) {
        availabilityGuard.addListener(new AvailabilityGuard.AvailabilityListener(){

            @Override
            public void available() {
                msgLog.log("Database is now ready");
            }

            @Override
            public void unavailable() {
                msgLog.log("Database is now unavailable");
            }
        });
    }

    public static class Configuration {
        public static final Setting<Boolean> ephemeral = Settings.setting("unsupported.dbms.ephemeral", Settings.BOOLEAN, "false");
        public static final Setting<String> ephemeral_keep_logical_logs = Settings.setting("dbms.tx_log.rotation.retention_policy", Settings.STRING, "1 files", Settings.illegalValueMessage("must be `true`/`false` or of format '<number><optional unit> <type>' for example `100M size` for limiting logical log space on disk to 100Mb, or `200k txs` for limiting the number of transactions to keep to 200 000", Settings.matches(".+")));
        public static final Setting<String> lock_manager = Settings.setting("unsupported.dbms.lock_manager", Settings.STRING, "");
        public static final Setting<String> tracer = Settings.setting("unsupported.dbms.tracer", Settings.STRING, (String)null);
        public static final Setting<String> editionName = Settings.setting("unsupported.dbms.edition", Settings.STRING, Edition.unknown.toString());
    }

    public static interface Dependencies {
        public Monitors monitors();

        public LogProvider userLogProvider();

        public Iterable<Class<?>> settingsClasses();

        public Iterable<KernelExtensionFactory<?>> kernelExtensions();

        public Map<String, URLAccessRule> urlAccessRules();

        public Iterable<QueryEngineProvider> executionEngines();
    }
}

