/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.lang.reflect.Type;
import java.util.function.Function;
import org.neo4j.kernel.api.proc.Neo4jTypes;
import org.neo4j.kernel.impl.proc.Neo4jValue;
import org.neo4j.kernel.impl.proc.ParseUtil;

public class ListConverter
implements Function<String, Neo4jValue> {
    private final Type type;
    private final Neo4jTypes.AnyType neoType;

    public ListConverter(Type type, Neo4jTypes.AnyType neoType) {
        this.type = type;
        this.neoType = neoType;
    }

    @Override
    public Neo4jValue apply(String s) {
        String value = s.trim();
        if (value.equalsIgnoreCase("null")) {
            return Neo4jValue.ntList(null, this.neoType);
        }
        return Neo4jValue.ntList(ParseUtil.parseList(value, this.type), this.neoType);
    }
}

