/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import java.util.function.Supplier;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.graphdb.TransientFailureException;
import org.neo4j.graphdb.TransientTransactionFailureException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.ConstraintViolationTransactionFailureException;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.PropertyContainerLocker;

public class TopLevelTransaction
implements InternalTransaction {
    private static final PropertyContainerLocker locker = new PropertyContainerLocker();
    private boolean successCalled;
    private final Supplier<Statement> stmt;
    private final KernelTransaction transaction;

    public TopLevelTransaction(KernelTransaction transaction, Supplier<Statement> stmt) {
        this.stmt = stmt;
        this.transaction = transaction;
    }

    public void failure() {
        this.transaction.failure();
    }

    public void success() {
        this.successCalled = true;
        this.transaction.success();
    }

    public final void terminate() {
        this.transaction.markForTermination((Status)Status.Transaction.Terminated);
    }

    public void close() {
        try {
            if (this.transaction.isOpen()) {
                this.transaction.close();
            }
        }
        catch (TransientFailureException e) {
            throw e;
        }
        catch (ConstraintViolationTransactionFailureException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
        catch (TransactionTerminatedException | KernelException e) {
            Status.Code statusCode = ((Status.HasStatus)e).status().code();
            if (statusCode.classification() == Status.Classification.TransientError) {
                throw new TransientTransactionFailureException(this.closeFailureMessage() + ": " + statusCode.description(), e);
            }
            throw new TransactionFailureException(this.closeFailureMessage(), e);
        }
        catch (Exception e) {
            throw new TransactionFailureException(this.closeFailureMessage(), (Throwable)e);
        }
    }

    private String closeFailureMessage() {
        return this.successCalled ? "Transaction was marked as successful, but unable to commit transaction so rolled back." : "Unable to rollback transaction";
    }

    public Lock acquireWriteLock(PropertyContainer entity) {
        return locker.exclusiveLock(this.stmt, entity);
    }

    public Lock acquireReadLock(PropertyContainer entity) {
        return locker.sharedLock(this.stmt, entity);
    }

    @Override
    public KernelTransaction.Type transactionType() {
        return this.transaction.transactionType();
    }

    @Override
    public AccessMode mode() {
        return this.transaction.mode();
    }

    @Override
    public KernelTransaction.Revertable overrideWith(AccessMode mode) {
        return this.transaction.overrideWith(mode);
    }
}

