/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import java.util.function.Supplier;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.PropertyContainerLocker;

public class PlaceboTransaction
implements InternalTransaction {
    private static final PropertyContainerLocker locker = new PropertyContainerLocker();
    private final Supplier<Statement> stmt;
    private final KernelTransaction currentTransaction;
    private boolean success;

    public PlaceboTransaction(Supplier<KernelTransaction> currentTransaction, Supplier<Statement> stmt) {
        this.stmt = stmt;
        this.currentTransaction = currentTransaction.get();
    }

    public void terminate() {
        this.currentTransaction.markForTermination((Status)Status.Transaction.Terminated);
    }

    public void failure() {
        this.currentTransaction.failure();
    }

    public void success() {
        this.success = true;
    }

    public void close() {
        if (!this.success) {
            this.currentTransaction.failure();
        }
    }

    public Lock acquireWriteLock(PropertyContainer entity) {
        return locker.exclusiveLock(this.stmt, entity);
    }

    public Lock acquireReadLock(PropertyContainer entity) {
        return locker.sharedLock(this.stmt, entity);
    }

    @Override
    public KernelTransaction.Type transactionType() {
        return this.currentTransaction.transactionType();
    }

    @Override
    public AccessMode mode() {
        return this.currentTransaction.mode();
    }

    @Override
    public KernelTransaction.Revertable overrideWith(AccessMode mode) {
        return this.currentTransaction.overrideWith(mode);
    }
}

