/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.security;

import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.kernel.api.security.AccessMode;

public class AccessModeSnapshot
implements AccessMode {
    private final boolean allowsReads;
    private final boolean allowsWrites;
    private final boolean allowsSchemaWrites;
    private final AccessMode originalMode;

    public static AccessMode create(AccessMode accessMode) {
        return new AccessModeSnapshot(accessMode);
    }

    private AccessModeSnapshot(AccessMode accessMode) {
        this.allowsReads = accessMode.allowsReads();
        this.allowsWrites = accessMode.allowsWrites();
        this.allowsSchemaWrites = accessMode.allowsSchemaWrites();
        this.originalMode = accessMode;
    }

    @Override
    public boolean allowsReads() {
        return this.allowsReads;
    }

    @Override
    public boolean allowsWrites() {
        return this.allowsWrites;
    }

    @Override
    public boolean allowsSchemaWrites() {
        return this.allowsSchemaWrites;
    }

    @Override
    public AuthorizationViolationException onViolation(String msg) {
        return this.originalMode.onViolation(msg);
    }

    @Override
    public String name() {
        return this.originalMode.name();
    }

    @Override
    public String username() {
        return this.originalMode.username();
    }

    @Override
    public AccessMode getOriginalAccessMode() {
        return this.originalMode.getOriginalAccessMode();
    }

    @Override
    public AccessMode getSnapshot() {
        return this;
    }
}

