/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.dbms;

import org.neo4j.collection.RawIterator;
import org.neo4j.kernel.api.dbms.DbmsOperations;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.proc.BasicContext;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.api.proc.QualifiedName;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.api.security.AuthSubject;
import org.neo4j.kernel.impl.proc.Procedures;

public class NonTransactionalDbmsOperations
implements DbmsOperations {
    private final Procedures procedures;

    public NonTransactionalDbmsOperations(Procedures procedures) {
        this.procedures = procedures;
    }

    @Override
    public RawIterator<Object[], ProcedureException> procedureCallDbms(QualifiedName name, Object[] input, AccessMode mode) throws ProcedureException {
        BasicContext ctx = new BasicContext();
        AccessMode originalMode = mode.getOriginalAccessMode();
        if (originalMode instanceof AuthSubject) {
            ctx.put(Context.AUTH_SUBJECT, (AuthSubject)originalMode);
        }
        return this.procedures.callProcedure(ctx, name, input);
    }

    @Override
    public Object functionCallDbms(QualifiedName name, Object[] input, AccessMode mode) throws ProcedureException {
        BasicContext ctx = new BasicContext();
        if (mode instanceof AuthSubject) {
            AuthSubject subject = (AuthSubject)mode;
            ctx.put(Context.AUTH_SUBJECT, subject);
        }
        return this.procedures.callFunction(ctx, name, input);
    }
}

