/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.security;

import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.api.exceptions.Status;

public interface AccessMode {
    public boolean allowsReads();

    public boolean allowsWrites();

    public boolean allowsSchemaWrites();

    public AuthorizationViolationException onViolation(String var1);

    public String name();

    default public String username() {
        return "";
    }

    default public AccessMode getOriginalAccessMode() {
        return this;
    }

    default public boolean isOverridden() {
        return false;
    }

    default public boolean allowsProcedureWith(String[] allowed) throws InvalidArgumentsException {
        return false;
    }

    public AccessMode getSnapshot();

    public static enum Static implements AccessMode
    {
        NONE{

            @Override
            public boolean allowsReads() {
                return false;
            }

            @Override
            public boolean allowsWrites() {
                return false;
            }

            @Override
            public boolean allowsSchemaWrites() {
                return false;
            }
        }
        ,
        CREDENTIALS_EXPIRED{

            @Override
            public boolean allowsReads() {
                return false;
            }

            @Override
            public boolean allowsWrites() {
                return false;
            }

            @Override
            public boolean allowsSchemaWrites() {
                return false;
            }

            @Override
            public AuthorizationViolationException onViolation(String msg) {
                return new AuthorizationViolationException(String.format(msg + "%n%nThe credentials you provided were valid, but must be " + "changed before you can " + "use this instance. If this is the first time you are using Neo4j, this is to " + "ensure you are not using the default credentials in production. If you are not " + "using default credentials, you are getting this message because an administrator " + "requires a password change.%n" + "Changing your password is easy to do via the Neo4j Browser.%n" + "If you are connecting via a shell or programmatically via a driver, " + "just issue a `CALL dbms.changePassword('new password')` statement in the current " + "session, and then restart your driver with the new password configured.", new Object[0]), (Status)Status.Security.CredentialsExpired);
            }
        }
        ,
        READ{

            @Override
            public boolean allowsReads() {
                return true;
            }

            @Override
            public boolean allowsWrites() {
                return false;
            }

            @Override
            public boolean allowsSchemaWrites() {
                return false;
            }
        }
        ,
        WRITE_ONLY{

            @Override
            public boolean allowsReads() {
                return false;
            }

            @Override
            public boolean allowsWrites() {
                return true;
            }

            @Override
            public boolean allowsSchemaWrites() {
                return false;
            }
        }
        ,
        WRITE{

            @Override
            public boolean allowsReads() {
                return true;
            }

            @Override
            public boolean allowsWrites() {
                return true;
            }

            @Override
            public boolean allowsSchemaWrites() {
                return false;
            }
        }
        ,
        FULL{

            @Override
            public boolean allowsReads() {
                return true;
            }

            @Override
            public boolean allowsWrites() {
                return true;
            }

            @Override
            public boolean allowsSchemaWrites() {
                return true;
            }
        };


        @Override
        public AuthorizationViolationException onViolation(String msg) {
            return new AuthorizationViolationException(msg);
        }

        @Override
        public AccessMode getSnapshot() {
            return this;
        }
    }
}

