/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query;

import java.util.Map;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.ExecutingQuery;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.QueryRegistryOperations;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.dbms.DbmsOperations;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.PropertyContainerLocker;
import org.neo4j.kernel.impl.query.TransactionalContext;

public class Neo4jTransactionalContext
implements TransactionalContext {
    private final GraphDatabaseQueryService graph;
    private final ThreadToStatementContextBridge txBridge;
    private final KernelTransaction.Type transactionType;
    private final AccessMode mode;
    private final DbmsOperations.Factory dbmsOperationsFactory;
    private final Guard guard;
    private InternalTransaction transaction;
    private Statement statement;
    private ExecutingQuery executingQuery;
    private PropertyContainerLocker locker;
    private boolean isOpen = true;

    public Neo4jTransactionalContext(GraphDatabaseQueryService graph, InternalTransaction initialTransaction, Statement initialStatement, String queryText, Map<String, Object> queryParameters, PropertyContainerLocker locker) {
        this(graph, initialTransaction, initialTransaction.transactionType(), initialTransaction.mode(), initialStatement, initialStatement.queryRegistration().startQueryExecution(queryText, queryParameters), locker, (ThreadToStatementContextBridge)graph.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class), (DbmsOperations.Factory)graph.getDependencyResolver().resolveDependency(DbmsOperations.Factory.class), (Guard)graph.getDependencyResolver().resolveDependency(Guard.class));
    }

    public Neo4jTransactionalContext(GraphDatabaseQueryService graph, InternalTransaction initialTransaction, KernelTransaction.Type transactionType, AccessMode transactionMode, Statement initialStatement, ExecutingQuery executingQuery, PropertyContainerLocker locker, ThreadToStatementContextBridge txBridge, DbmsOperations.Factory dbmsOperationsFactory, Guard guard) {
        this.graph = graph;
        this.transaction = initialTransaction;
        this.transactionType = transactionType;
        this.mode = transactionMode;
        this.statement = initialStatement;
        this.executingQuery = executingQuery;
        this.locker = locker;
        this.txBridge = txBridge;
        this.dbmsOperationsFactory = dbmsOperationsFactory;
        this.guard = guard;
    }

    @Override
    public ReadOperations readOperations() {
        return this.statement.readOperations();
    }

    @Override
    public DbmsOperations dbmsOperations() {
        return this.dbmsOperationsFactory.newInstance(this.txBridge.getKernelTransactionBoundToThisThread(true));
    }

    @Override
    public boolean isTopLevelTx() {
        return this.transaction.transactionType() == KernelTransaction.Type.implicit;
    }

    @Override
    public void close(boolean success) {
        if (this.isOpen) {
            try {
                this.statement.queryRegistration().unregisterExecutingQuery(this.executingQuery);
                this.statement.close();
                if (success) {
                    this.transaction.success();
                } else {
                    this.transaction.failure();
                }
                this.transaction.close();
            }
            finally {
                this.statement = null;
                this.transaction = null;
                this.isOpen = false;
            }
        }
    }

    @Override
    public void commitAndRestartTx() {
        QueryRegistryOperations oldQueryRegistryOperations = this.statement.queryRegistration();
        InternalTransaction oldTransaction = this.transaction;
        KernelTransaction oldKernelTx = this.txBridge.getKernelTransactionBoundToThisThread(true);
        this.txBridge.unbindTransactionFromCurrentThread();
        this.transaction = this.graph.beginTransaction(this.transactionType, this.mode);
        this.statement = this.txBridge.get();
        this.statement.queryRegistration().registerExecutingQuery(this.executingQuery);
        KernelTransaction kernelTx = this.txBridge.getKernelTransactionBoundToThisThread(true);
        this.txBridge.unbindTransactionFromCurrentThread();
        this.txBridge.bindTransactionToCurrentThread(oldKernelTx);
        oldQueryRegistryOperations.unregisterExecutingQuery(this.executingQuery);
        oldTransaction.success();
        oldTransaction.close();
        this.txBridge.unbindTransactionFromCurrentThread();
        this.txBridge.bindTransactionToCurrentThread(kernelTx);
    }

    @Override
    public void cleanForReuse() {
        this.statement.queryRegistration().unregisterExecutingQuery(this.executingQuery);
        this.statement.close();
        this.statement = this.txBridge.get();
        this.statement.queryRegistration().registerExecutingQuery(this.executingQuery);
    }

    @Override
    public TransactionalContext provideContext() {
        if (this.isOpen) {
            return this;
        }
        InternalTransaction transaction = this.graph.beginTransaction(this.transactionType, this.mode);
        Statement statement = this.txBridge.get();
        return new Neo4jTransactionalContext(this.graph, transaction, statement, this.executingQuery.queryText(), this.executingQuery.queryParameters(), this.locker);
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public GraphDatabaseQueryService graph() {
        return this.graph;
    }

    @Override
    public Statement statement() {
        return this.statement;
    }

    @Override
    public void check() {
        this.guard.check((KernelStatement)this.statement);
    }

    @Override
    public TxStateHolder stateView() {
        return (KernelStatement)this.statement;
    }

    @Override
    public Lock acquireWriteLock(PropertyContainer p) {
        return this.locker.exclusiveLock(this.statement, p);
    }

    @Override
    public KernelTransaction.Revertable restrictCurrentTransaction(AccessMode accessMode) {
        return this.transaction.overrideWith(accessMode);
    }

    @Override
    public AccessMode accessMode() {
        return this.mode;
    }
}

