/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.security;

import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.api.security.AuthSubject;

public class OverriddenAccessMode
implements AccessMode {
    private final AccessMode originalMode;
    private final AccessMode overriddenMode;

    public OverriddenAccessMode(AccessMode originalMode, AccessMode overriddenMode) {
        this.originalMode = originalMode;
        this.overriddenMode = overriddenMode;
    }

    @Override
    public boolean allowsReads() {
        return this.overriddenMode.allowsReads() && (this.overriddenMode.overrideOriginalMode() || this.originalMode.allowsReads());
    }

    @Override
    public boolean allowsWrites() {
        return this.overriddenMode.allowsWrites() && (this.overriddenMode.overrideOriginalMode() || this.originalMode.allowsWrites());
    }

    @Override
    public boolean allowsSchemaWrites() {
        return this.overriddenMode.allowsSchemaWrites() && (this.overriddenMode.overrideOriginalMode() || this.originalMode.allowsSchemaWrites());
    }

    @Override
    public boolean overrideOriginalMode() {
        return false;
    }

    @Override
    public AuthorizationViolationException onViolation(String msg) {
        return this.overriddenMode.onViolation(msg);
    }

    @Override
    public String name() {
        if (this.overriddenMode.overrideOriginalMode()) {
            return this.originalMode.name() + " overridden by " + this.overriddenMode.name();
        }
        return this.originalMode.name() + " restricted to " + this.overriddenMode.name();
    }

    public String username() {
        return OverriddenAccessMode.getUsernameFromAccessMode(this.originalMode);
    }

    public static String getUsernameFromAccessMode(AccessMode accessMode) {
        if (accessMode instanceof AuthSubject) {
            return ((AuthSubject)accessMode).username();
        }
        if (accessMode instanceof OverriddenAccessMode) {
            return ((OverriddenAccessMode)accessMode).username();
        }
        return "";
    }
}

