/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.cursor.Cursor;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.operations.EntityReadOperations;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.storageengine.api.Direction;
import org.neo4j.storageengine.api.NodeItem;

class TwoPhaseNodeForRelationshipLocking {
    private final PrimitiveLongSet nodeIds = Primitive.longSet();
    private final EntityReadOperations reads;
    private final ThrowingConsumer<Long, KernelException> relIdAction;
    private boolean retry = true;
    private long firstRelId;
    private boolean first;
    private final RelationshipVisitor<RuntimeException> collectNodeIdVisitor = (relId, type, startNode, endNode) -> {
        if (this.firstRelId == -1L) {
            this.firstRelId = relId;
        }
        this.nodeIds.add(startNode);
        this.nodeIds.add(endNode);
    };
    private final RelationshipVisitor<KernelException> relationshipConsumingVisitor = new RelationshipVisitor<KernelException>(){

        @Override
        public void visit(long relId, int type, long startNode, long endNode) throws KernelException {
            if (TwoPhaseNodeForRelationshipLocking.this.first) {
                TwoPhaseNodeForRelationshipLocking.this.first = false;
                if (relId != TwoPhaseNodeForRelationshipLocking.this.firstRelId) {
                    TwoPhaseNodeForRelationshipLocking.this.retry = true;
                    return;
                }
            }
            TwoPhaseNodeForRelationshipLocking.this.relIdAction.accept((Object)relId);
        }
    };

    TwoPhaseNodeForRelationshipLocking(EntityReadOperations reads, ThrowingConsumer<Long, KernelException> relIdAction) {
        this.reads = reads;
        this.relIdAction = relIdAction;
    }

    void lockAllNodesAndConsumeRelationships(long nodeId, KernelStatement state) throws KernelException {
        block18: while (this.retry) {
            RelationshipIterator relationships;
            this.retry = false;
            this.first = true;
            this.firstRelId = -1L;
            try (Cursor<NodeItem> cursor = this.reads.nodeCursorById(state, nodeId);){
                relationships = ((NodeItem)cursor.get()).getRelationships(Direction.BOTH);
                while (relationships.hasNext()) {
                    this.reads.relationshipVisit(state, relationships.next(), this.collectNodeIdVisitor);
                }
            }
            PrimitiveLongIterator iterator = this.nodeIds.iterator();
            while (iterator.hasNext()) {
                state.locks().optimistic().acquireExclusive(ResourceTypes.NODE, iterator.next());
            }
            cursor = this.reads.nodeCursorById(state, nodeId);
            var5_4 = null;
            try {
                relationships = ((NodeItem)cursor.get()).getRelationships(Direction.BOTH);
                while (relationships.hasNext()) {
                    this.reads.relationshipVisit(state, relationships.next(), this.relationshipConsumingVisitor);
                    if (!this.retry) continue;
                    PrimitiveLongIterator iterator2 = this.nodeIds.iterator();
                    while (iterator2.hasNext()) {
                        state.locks().optimistic().releaseExclusive(ResourceTypes.NODE, iterator2.next());
                    }
                    this.nodeIds.clear();
                    continue block18;
                }
            }
            catch (Throwable throwable) {
                var5_4 = throwable;
                throw throwable;
            }
            finally {
                if (cursor == null) continue;
                if (var5_4 != null) {
                    try {
                        cursor.close();
                    }
                    catch (Throwable throwable) {
                        var5_4.addSuppressed(throwable);
                    }
                    continue;
                }
                cursor.close();
            }
        }
    }
}

