/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.time.Clock;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.kernel.api.ExecutingQuery;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.operations.QueryRegistrationOperations;
import org.neo4j.kernel.impl.util.MonotonicCounter;

public class StackingQueryRegistrationOperations
implements QueryRegistrationOperations {
    public static final MonotonicCounter LAST_QUERY_ID = MonotonicCounter.newAtomicMonotonicCounter();
    private final MonotonicCounter lastQueryId;
    private final Clock clock;

    public StackingQueryRegistrationOperations(MonotonicCounter lastQueryId, Clock clock) {
        this.lastQueryId = lastQueryId;
        this.clock = clock;
    }

    @Override
    public Stream<ExecutingQuery> executingQueries(KernelStatement statement) {
        return statement.executingQueryList().queries();
    }

    @Override
    public void registerExecutingQuery(KernelStatement statement, ExecutingQuery executingQuery) {
        statement.startQueryExecution(executingQuery);
    }

    @Override
    public ExecutingQuery startQueryExecution(KernelStatement statement, String queryText, Map<String, Object> queryParameters) {
        long queryId = this.lastQueryId.incrementAndGet();
        ExecutingQuery executingQuery = new ExecutingQuery(queryId, statement.authSubjectName(), queryText, queryParameters, this.clock.millis());
        statement.startQueryExecution(executingQuery);
        return executingQuery;
    }

    @Override
    public void unregisterExecutingQuery(KernelStatement statement, ExecutingQuery executingQuery) {
        statement.stopQueryExecution(executingQuery);
    }
}

