/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration.docs;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.kernel.configuration.docs.AsciiDocListGenerator;
import org.neo4j.kernel.configuration.docs.SettingDescription;
import org.neo4j.kernel.configuration.docs.SettingsDescription;

public class SettingsDocumenter {
    private static final Predicate<SettingDescription> REGULAR_SETTINGS = s -> !s.isDeprecated();
    private static final Predicate<SettingDescription> DEPRECATED_SETTINGS = SettingDescription::isDeprecated;
    private static final Pattern CONFIG_SETTING_PATTERN = Pattern.compile("\\+?[a-z0-9]+((\\.|_)[a-z0-9]+)+\\+?");
    private static final Pattern NUMBER_OR_IP = Pattern.compile("[0-9\\.]+");
    private static final List<String> CONFIG_NAMES_BLACKLIST = Arrays.asList("round_robin", "keep_all", "keep_last", "keep_none", "metrics.neo4j", "i.e", "e.g", "fixed_ascending", "fixed_descending", "high_limit");
    public static final String IFDEF_HTMLOUTPUT = String.format("ifndef::nonhtmloutput[]%n", new Object[0]);
    public static final String IFDEF_NONHTMLOUTPUT = String.format("ifdef::nonhtmloutput[]%n", new Object[0]);
    public static final String ENDIF = String.format("endif::nonhtmloutput[]%n%n", new Object[0]);
    private PrintStream out;

    public String document(Stream<Class<?>> settings) throws Exception {
        SettingsDescription combinedDescription = settings.map(SettingsDescription::describe).reduce(SettingsDescription::union).get();
        return this.document(combinedDescription);
    }

    public String document(Class<?> settings) throws Exception {
        return this.document(SettingsDescription.describe(settings));
    }

    public String document(SettingsDescription desc) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.out = new PrintStream(baos);
        this.createOverviewTable(REGULAR_SETTINGS, desc.id(), desc.description(), desc);
        this.createOverviewTable(DEPRECATED_SETTINGS, desc.id() + "-deprecated", "Deprecated settings", desc);
        desc.settings().forEach(setting -> {
            this.documentForHTML((SettingDescription)setting);
            this.documentForPDF((SettingDescription)setting);
        });
        this.out.flush();
        return baos.toString();
    }

    private void createOverviewTable(Predicate<SettingDescription> filter, String tableId, String tableDescription, SettingsDescription desc) {
        List<SettingDescription> settings = desc.settings().filter(filter).collect(Collectors.toList());
        if (settings.size() > 0) {
            this.out.print(new AsciiDocListGenerator(tableId, tableDescription, true).generateListAndTableCombo(settings));
        }
    }

    private void documentForHTML(SettingDescription item) {
        this.out.print(IFDEF_HTMLOUTPUT);
        this.document(item.formatted(p -> this.formatParagraph(item.name(), (String)p, this::settingReferenceForHTML)));
        this.out.print(ENDIF);
    }

    private void documentForPDF(SettingDescription item) {
        this.out.print(IFDEF_NONHTMLOUTPUT);
        this.document(item.formatted(p -> this.formatParagraph(item.name(), (String)p, this::settingReferenceForPDF)));
        this.out.print(ENDIF);
    }

    private void document(SettingDescription item) {
        this.out.printf("[[%s]]%n.%s%n[cols=\"<1h,<4\"]%n|===%n|Description a|%s%n|Valid values a|%s%n", item.id(), item.name(), item.description(), item.validationMessage());
        if (item.hasDefault()) {
            this.out.printf("|Default value m|%s%n", item.defaultValue());
        }
        if (item.isMandatory()) {
            this.out.printf("|Mandatory a|%s%n", item.mandatoryDescription());
        }
        if (item.isDeprecated()) {
            this.out.printf("|Deprecated a|%s%n", item.deprecationMessage());
        }
        this.out.printf("|===%n", new Object[0]);
    }

    private String formatParagraph(String settingName, String paragraph, Function<String, String> renderReferenceToOtherSetting) {
        return this.ensureEndsWithPeriod(this.transformSettingNames(paragraph, settingName, renderReferenceToOtherSetting));
    }

    private String transformSettingNames(String text, String settingBeingRendered, Function<String, String> transform) {
        Matcher matcher = CONFIG_SETTING_PATTERN.matcher(text);
        StringBuffer result = new StringBuffer(256);
        while (matcher.find()) {
            String match = matcher.group();
            if (match.endsWith(".log")) {
                match = "_" + match + "_";
            } else if (match.startsWith("+") && match.endsWith("+")) {
                match = match.replaceAll("^\\+|\\+$", "");
            } else if (match.equals(settingBeingRendered)) {
                match = "`" + match + "`";
            } else if (!CONFIG_NAMES_BLACKLIST.contains(match) && !NUMBER_OR_IP.matcher(match).matches()) {
                match = transform.apply(match);
            }
            matcher.appendReplacement(result, match);
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private String ensureEndsWithPeriod(String message) {
        if (!message.endsWith(".") && !message.endsWith(". ")) {
            message = message + ".";
        }
        return message;
    }

    private String settingReferenceForHTML(String settingName) {
        return "<<config_" + settingName + "," + settingName + ">>";
    }

    private String settingReferenceForPDF(String settingName) {
        return "`" + settingName + "`";
    }
}

