/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.proc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.proc.Neo4jTypes;
import org.neo4j.kernel.impl.proc.Neo4jValue;

public class ProcedureSignature {
    public static List<FieldSignature> VOID = Collections.unmodifiableList(new ArrayList());
    private final ProcedureName name;
    private final List<FieldSignature> inputSignature;
    private final List<FieldSignature> outputSignature;
    private final Mode mode;
    private final Optional<String> deprecated;
    private final String[] allowed;
    private final Optional<String> description;

    public ProcedureSignature(ProcedureName name, List<FieldSignature> inputSignature, List<FieldSignature> outputSignature, Mode mode, Optional<String> deprecated, String[] allowed, Optional<String> description) {
        this.name = name;
        this.inputSignature = Collections.unmodifiableList(inputSignature);
        this.outputSignature = outputSignature == VOID ? outputSignature : Collections.unmodifiableList(outputSignature);
        this.mode = mode;
        this.deprecated = deprecated;
        this.allowed = allowed;
        this.description = description;
    }

    public ProcedureName name() {
        return this.name;
    }

    public Mode mode() {
        return this.mode;
    }

    public Optional<String> deprecated() {
        return this.deprecated;
    }

    public String[] allowed() {
        return this.allowed;
    }

    public List<FieldSignature> inputSignature() {
        return this.inputSignature;
    }

    public List<FieldSignature> outputSignature() {
        return this.outputSignature;
    }

    public boolean isVoid() {
        return this.outputSignature == VOID;
    }

    public Optional<String> description() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcedureSignature that = (ProcedureSignature)o;
        return this.name.equals(that.name) && this.inputSignature.equals(that.inputSignature) && this.outputSignature.equals(that.outputSignature) && this.isVoid() == that.isVoid();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        String strInSig;
        String string = strInSig = this.inputSignature == null ? "..." : Iterables.toString(this.inputSignature, (String)", ");
        if (this.isVoid()) {
            return String.format("%s(%s) :: VOID", this.name, strInSig);
        }
        String strOutSig = this.outputSignature == null ? "..." : Iterables.toString(this.outputSignature, (String)", ");
        return String.format("%s(%s) :: (%s)", this.name, strInSig, strOutSig);
    }

    public static Builder procedureSignature(String ... namespaceAndName) {
        String[] namespace = namespaceAndName.length > 1 ? Arrays.copyOf(namespaceAndName, namespaceAndName.length - 1) : new String[]{};
        String name = namespaceAndName[namespaceAndName.length - 1];
        return ProcedureSignature.procedureSignature(namespace, name);
    }

    public static Builder procedureSignature(ProcedureName name) {
        return new Builder(name.namespace, name.name);
    }

    public static Builder procedureSignature(String[] namespace, String name) {
        return new Builder(namespace, name);
    }

    public static ProcedureName procedureName(String ... namespaceAndName) {
        return ProcedureSignature.procedureSignature(namespaceAndName).build().name();
    }

    public static class Builder {
        private final ProcedureName name;
        private final List<FieldSignature> inputSignature = new LinkedList<FieldSignature>();
        private List<FieldSignature> outputSignature = new LinkedList<FieldSignature>();
        private Mode mode = Mode.READ_ONLY;
        private Optional<String> deprecated = Optional.empty();
        private String[] allowed = new String[0];
        private Optional<String> description = Optional.empty();

        public Builder(String[] namespace, String name) {
            this.name = new ProcedureName(namespace, name);
        }

        public Builder mode(Mode mode) {
            this.mode = mode;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.of(description);
            return this;
        }

        public Builder deprecatedBy(String deprecated) {
            this.deprecated = Optional.of(deprecated);
            return this;
        }

        public Builder in(String name, Neo4jTypes.AnyType type) {
            this.inputSignature.add(new FieldSignature(name, type));
            return this;
        }

        public Builder out(String name, Neo4jTypes.AnyType type) {
            this.outputSignature.add(new FieldSignature(name, type));
            return this;
        }

        public Builder out(List<FieldSignature> fields) {
            this.outputSignature = fields;
            return this;
        }

        public Builder allowed(String[] allowed) {
            this.allowed = allowed;
            return this;
        }

        public ProcedureSignature build() {
            return new ProcedureSignature(this.name, this.inputSignature, this.outputSignature, this.mode, this.deprecated, this.allowed, this.description);
        }
    }

    public static enum Mode {
        READ_ONLY,
        READ_WRITE,
        SCHEMA_WRITE,
        DBMS;

    }

    public static class FieldSignature {
        private final String name;
        private final Neo4jTypes.AnyType type;
        private final Optional<Neo4jValue> defaultValue;

        public FieldSignature(String name, Neo4jTypes.AnyType type) {
            this(name, type, Optional.empty());
        }

        public FieldSignature(String name, Neo4jTypes.AnyType type, Optional<Neo4jValue> defaultValue) {
            this.name = name;
            this.type = type;
            this.defaultValue = defaultValue;
        }

        public String name() {
            return this.name;
        }

        public Neo4jTypes.AnyType neo4jType() {
            return this.type;
        }

        public Optional<Neo4jValue> defaultValue() {
            return this.defaultValue;
        }

        public String toString() {
            String nameValue = this.defaultValue.isPresent() ? this.name + " = " + this.defaultValue.get().value() : this.name;
            return String.format("%s :: %s", nameValue, this.type);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldSignature that = (FieldSignature)o;
            return this.name.equals(that.name) && this.type.equals(that.type);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.type.hashCode();
            return result;
        }
    }

    public static class ProcedureName {
        private final String[] namespace;
        private final String name;

        public ProcedureName(List<String> namespace, String name) {
            this(namespace.toArray(new String[namespace.size()]), name);
        }

        public ProcedureName(String[] namespace, String name) {
            this.namespace = namespace;
            this.name = name;
        }

        public String[] namespace() {
            return this.namespace;
        }

        public String name() {
            return this.name;
        }

        public String toString() {
            String strNamespace = this.namespace.length > 0 ? Iterables.toString(Arrays.asList(this.namespace), (String)".") + "." : "";
            return String.format("%s%s", strNamespace, this.name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProcedureName that = (ProcedureName)o;
            return Arrays.equals(this.namespace, that.namespace) && this.name.equals(that.name);
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.namespace);
            result = 31 * result + this.name.hashCode();
            return result;
        }
    }
}

