/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.udc;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.neo4j.concurrent.DecayingFlags;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.udc.UsageDataKey;
import org.neo4j.udc.UsageDataKeys;

public class UsageData
extends LifecycleAdapter {
    private final ConcurrentHashMap<UsageDataKey, Object> store = new ConcurrentHashMap();
    private final JobScheduler scheduler;
    private JobScheduler.JobHandle featureDecayJob;

    public UsageData(JobScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public <T> void set(UsageDataKey<T> key, T value) {
        this.store.put(key, value);
    }

    public <T> T get(UsageDataKey<T> key) {
        Object o = this.store.get(key);
        if (o == null) {
            T value = key.generateDefaultValue();
            if (value == null) {
                return null;
            }
            this.store.putIfAbsent(key, value);
            return this.get(key);
        }
        return (T)o;
    }

    public void stop() throws Throwable {
        if (this.featureDecayJob != null) {
            this.featureDecayJob.cancel(false);
        }
    }

    public void start() throws Throwable {
        this.featureDecayJob = this.scheduler.schedule(JobScheduler.Groups.udc, () -> ((DecayingFlags)this.get(UsageDataKeys.features)).sweep(), 1L, TimeUnit.DAYS);
    }
}

