/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.File;
import java.io.IOException;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.TransactionId;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;

public class ReadOnlyTransactionIdStore
implements TransactionIdStore {
    private final long transactionId;
    private final long transactionChecksum;
    private final long logVersion;
    private final long byteOffset;

    public ReadOnlyTransactionIdStore(PageCache pageCache, File storeDir) throws IOException {
        long id = 0L;
        long checksum = 0L;
        long logVersion = 0L;
        long byteOffset = 0L;
        if (NeoStores.isStorePresent(pageCache, storeDir)) {
            File neoStore = new File(storeDir, "neostore");
            id = MetaDataStore.getRecord(pageCache, neoStore, MetaDataStore.Position.LAST_TRANSACTION_ID);
            checksum = MetaDataStore.getRecord(pageCache, neoStore, MetaDataStore.Position.LAST_TRANSACTION_CHECKSUM);
            logVersion = MetaDataStore.getRecord(pageCache, neoStore, MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_VERSION);
            byteOffset = MetaDataStore.getRecord(pageCache, neoStore, MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET);
        }
        this.transactionId = id;
        this.transactionChecksum = checksum;
        this.logVersion = logVersion;
        this.byteOffset = byteOffset;
    }

    @Override
    public long nextCommittingTransactionId() {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    @Override
    public void transactionCommitted(long transactionId, long checksum, long commitTimestamp) {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    @Override
    public long getLastCommittedTransactionId() {
        return this.transactionId;
    }

    @Override
    public TransactionId getLastCommittedTransaction() {
        return new TransactionId(this.transactionId, this.transactionChecksum, 0L);
    }

    @Override
    public TransactionId getUpgradeTransaction() {
        return this.getLastCommittedTransaction();
    }

    @Override
    public long getLastClosedTransactionId() {
        return this.transactionId;
    }

    @Override
    public long[] getLastClosedTransaction() {
        return new long[]{this.transactionId, this.logVersion, this.byteOffset};
    }

    @Override
    public void setLastCommittedAndClosedTransactionId(long transactionId, long checksum, long commitTimestamp, long logByteOffset, long logVersion) {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    @Override
    public void transactionClosed(long transactionId, long logVersion, long logByteOffset) {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    @Override
    public boolean closedTransactionIdIsOnParWithOpenedTransactionId() {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    @Override
    public void flush() {
    }
}

