/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.IOException;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.storemigration.StoreFile;

public enum StoreType {
    NODE_LABEL(StoreFile.NODE_LABEL_STORE){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createDynamicArrayStore(this.getStoreName(), IdType.NODE_LABELS, GraphDatabaseSettings.label_block_size);
        }
    }
    ,
    NODE(StoreFile.NODE_STORE){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createNodeStore(this.getStoreName());
        }
    }
    ,
    PROPERTY_KEY_TOKEN_NAME(StoreFile.PROPERTY_KEY_TOKEN_NAMES_STORE){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createDynamicStringStore(this.getStoreName(), IdType.PROPERTY_KEY_TOKEN_NAME, 30);
        }
    }
    ,
    PROPERTY_KEY_TOKEN(StoreFile.PROPERTY_KEY_TOKEN_STORE){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createPropertyKeyTokenStore(this.getStoreName());
        }
    }
    ,
    PROPERTY_STRING(StoreFile.PROPERTY_STRING_STORE){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createDynamicStringStore(this.getStoreName(), IdType.STRING_BLOCK, GraphDatabaseSettings.string_block_size);
        }
    }
    ,
    PROPERTY_ARRAY(StoreFile.PROPERTY_ARRAY_STORE){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createDynamicArrayStore(this.getStoreName(), IdType.ARRAY_BLOCK, GraphDatabaseSettings.array_block_size);
        }
    }
    ,
    PROPERTY(StoreFile.PROPERTY_STORE){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createPropertyStore(this.getStoreName());
        }
    }
    ,
    RELATIONSHIP(StoreFile.RELATIONSHIP_STORE){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createRelationshipStore(this.getStoreName());
        }
    }
    ,
    RELATIONSHIP_TYPE_TOKEN_NAME(StoreFile.RELATIONSHIP_TYPE_TOKEN_NAMES_STORE){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createDynamicStringStore(this.getStoreName(), IdType.RELATIONSHIP_TYPE_TOKEN_NAME, 30);
        }
    }
    ,
    RELATIONSHIP_TYPE_TOKEN(StoreFile.RELATIONSHIP_TYPE_TOKEN_STORE){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createRelationshipTypeTokenStore(this.getStoreName());
        }
    }
    ,
    LABEL_TOKEN_NAME(StoreFile.LABEL_TOKEN_NAMES_STORE){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createDynamicStringStore(this.getStoreName(), IdType.LABEL_TOKEN_NAME, 30);
        }
    }
    ,
    LABEL_TOKEN(StoreFile.LABEL_TOKEN_STORE){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createLabelTokenStore(this.getStoreName());
        }
    }
    ,
    SCHEMA(StoreFile.SCHEMA_STORE){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createSchemaStore(this.getStoreName());
        }
    }
    ,
    RELATIONSHIP_GROUP(StoreFile.RELATIONSHIP_GROUP_STORE){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createRelationshipGroupStore(this.getStoreName());
        }
    }
    ,
    COUNTS(null, false){

        @Override
        public CountsTracker open(NeoStores neoStores) {
            return neoStores.createCountStore(".counts.db");
        }

        @Override
        void close(NeoStores me, Object object) {
            try {
                ((CountsTracker)object).shutdown();
            }
            catch (IOException e) {
                throw new UnderlyingStorageException(e);
            }
        }

        @Override
        public String getStoreName() {
            return ".counts.db";
        }
    }
    ,
    META_DATA(StoreFile.NEO_STORE){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createMetadataStore();
        }
    };

    private final boolean recordStore;
    private final StoreFile storeFile;

    private StoreType(StoreFile storeFile) {
        this(storeFile, true);
    }

    private StoreType(StoreFile storeFile, boolean recordStore) {
        this.storeFile = storeFile;
        this.recordStore = recordStore;
    }

    abstract Object open(NeoStores var1);

    public boolean isRecordStore() {
        return this.recordStore;
    }

    public String getStoreName() {
        return this.storeFile.fileNamePart();
    }

    public StoreFile getStoreFile() {
        return this.storeFile;
    }

    void close(NeoStores me, Object object) {
        ((CommonAbstractStore)object).close();
    }

    public static StoreType typeOf(String storeFileName) {
        StoreType[] values;
        for (StoreType value : values = StoreType.values()) {
            if (!value.getStoreName().equals(storeFileName) && !storeFileName.equals("neostore" + value.getStoreName())) continue;
            return value;
        }
        throw new IllegalArgumentException("No enum constant for " + storeFileName + " file.");
    }
}

