/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.factory;

import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.function.ThrowingAction;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.MultipleFoundException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.index.ReadableIndex;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.graphdb.security.URLAccessValidationError;
import org.neo4j.graphdb.traversal.BidirectionalTraversalDescription;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.PrefetchingResourceIterator;
import org.neo4j.helpers.collection.ResourceClosingIterator;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.legacyindex.AutoIndexing;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.impl.api.TokenAccess;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.coreapi.AutoIndexerFacade;
import org.neo4j.kernel.impl.coreapi.IndexManagerImpl;
import org.neo4j.kernel.impl.coreapi.IndexProviderImpl;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.PlaceboTransaction;
import org.neo4j.kernel.impl.coreapi.PropertyContainerLocker;
import org.neo4j.kernel.impl.coreapi.ReadOnlyIndexFacade;
import org.neo4j.kernel.impl.coreapi.ReadOnlyRelationshipIndexFacade;
import org.neo4j.kernel.impl.coreapi.RelationshipAutoIndexerFacade;
import org.neo4j.kernel.impl.coreapi.StandardNodeActions;
import org.neo4j.kernel.impl.coreapi.StandardRelationshipActions;
import org.neo4j.kernel.impl.coreapi.TopLevelTransaction;
import org.neo4j.kernel.impl.coreapi.schema.SchemaImpl;
import org.neo4j.kernel.impl.query.Neo4jTransactionalContext;
import org.neo4j.kernel.impl.query.QueryEngineProvider;
import org.neo4j.kernel.impl.query.QuerySession;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.traversal.BidirectionalTraversalDescriptionImpl;
import org.neo4j.kernel.impl.traversal.MonoDirectionalTraversalDescription;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.EntityType;

public class GraphDatabaseFacade
implements GraphDatabaseAPI {
    private static final PropertyContainerLocker locker = new PropertyContainerLocker();
    private Schema schema;
    private IndexManager indexManager;
    private NodeProxy.NodeActions nodeActions;
    private RelationshipProxy.RelationshipActions relActions;
    private SPI spi;

    public void init(SPI spi) {
        IndexProviderImpl idxProvider = new IndexProviderImpl(this, spi::currentStatement);
        this.spi = spi;
        this.relActions = new StandardRelationshipActions(spi::currentStatement, spi::currentTransaction, (ThrowingAction<RuntimeException>)((ThrowingAction)this::assertTransactionOpen), id -> new NodeProxy(this.nodeActions, id), this);
        this.nodeActions = new StandardNodeActions(spi::currentStatement, spi::currentTransaction, (ThrowingAction<RuntimeException>)((ThrowingAction)this::assertTransactionOpen), this.relActions, this);
        this.schema = new SchemaImpl(spi::currentStatement);
        AutoIndexerFacade<Node> nodeAutoIndexer = new AutoIndexerFacade<Node>(() -> new ReadOnlyIndexFacade<Node>((ReadableIndex<Node>)idxProvider.getOrCreateNodeIndex("node_auto_index", null)), spi.autoIndexing().nodes());
        RelationshipAutoIndexerFacade relAutoIndexer = new RelationshipAutoIndexerFacade(() -> new ReadOnlyRelationshipIndexFacade(idxProvider.getOrCreateRelationshipIndex("relationship_auto_index", null)), spi.autoIndexing().relationships());
        this.indexManager = new IndexManagerImpl(spi::currentStatement, idxProvider, nodeAutoIndexer, relAutoIndexer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Node createNode() {
        try (Statement statement = this.spi.currentStatement();){
            NodeProxy nodeProxy = new NodeProxy(this.nodeActions, statement.dataWriteOperations().nodeCreate());
            return nodeProxy;
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Node createNode(Label ... labels) {
        try (Statement statement = this.spi.currentStatement();){
            long nodeId = statement.dataWriteOperations().nodeCreate();
            for (Label label : labels) {
                int labelId = statement.tokenWriteOperations().labelGetOrCreateForName(label.name());
                try {
                    statement.dataWriteOperations().nodeAddLabel(nodeId, labelId);
                }
                catch (EntityNotFoundException e) {
                    throw new NotFoundException("No node with id " + nodeId + " found.", (Throwable)e);
                }
            }
            NodeProxy nodeProxy = new NodeProxy(this.nodeActions, nodeId);
            return nodeProxy;
        }
        catch (ConstraintValidationKernelException e) {
            throw new ConstraintViolationException("Unable to add label.", (Throwable)e);
        }
        catch (SchemaKernelException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
    }

    public Node getNodeById(long id) {
        if (id < 0L) {
            throw new NotFoundException(String.format("Node %d not found", id), (Throwable)new EntityNotFoundException(EntityType.NODE, id));
        }
        try (Statement statement = this.spi.currentStatement();){
            if (!statement.readOperations().nodeExists(id)) {
                throw new NotFoundException(String.format("Node %d not found", id), (Throwable)new EntityNotFoundException(EntityType.NODE, id));
            }
            NodeProxy nodeProxy = new NodeProxy(this.nodeActions, id);
            return nodeProxy;
        }
    }

    public Relationship getRelationshipById(long id) {
        if (id < 0L) {
            throw new NotFoundException(String.format("Relationship %d not found", id), (Throwable)new EntityNotFoundException(EntityType.RELATIONSHIP, id));
        }
        Throwable throwable = null;
        try (Statement statement = this.spi.currentStatement();){
            RelationshipProxy relationship = new RelationshipProxy(this.relActions, id);
            statement.readOperations().relationshipVisit(id, relationship);
            RelationshipProxy relationshipProxy = relationship;
            return relationshipProxy;
        }
        catch (EntityNotFoundException e) {
            try {
                throw new NotFoundException(String.format("Relationship %d not found", id), (Throwable)e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public IndexManager index() {
        return this.indexManager;
    }

    public Schema schema() {
        this.assertTransactionOpen();
        return this.schema;
    }

    public boolean isAvailable(long timeout) {
        return this.spi.databaseIsAvailable(timeout);
    }

    public void shutdown() {
        this.spi.shutdown();
    }

    public Transaction beginTx() {
        return this.beginTransaction(KernelTransaction.Type.explicit, AccessMode.Static.FULL);
    }

    @Override
    public InternalTransaction beginTransaction(KernelTransaction.Type type, AccessMode accessMode) {
        if (this.spi.isInOpenTransaction()) {
            return new PlaceboTransaction(this.spi::currentTransaction, this.spi::currentStatement);
        }
        return new TopLevelTransaction(this.spi.beginTransaction(type, accessMode), this.spi::currentStatement);
    }

    public Result execute(String query) throws QueryExecutionException {
        return this.execute(query, Collections.emptyMap());
    }

    public Result execute(String query, Map<String, Object> parameters) throws QueryExecutionException {
        InternalTransaction transaction = this.beginTransaction(KernelTransaction.Type.implicit, AccessMode.Static.FULL);
        Neo4jTransactionalContext transactionalContext = new Neo4jTransactionalContext(this.spi.queryService(), transaction, this.spi.currentStatement(), locker);
        return this.spi.executeQuery(query, parameters, QueryEngineProvider.embeddedSession(transactionalContext));
    }

    public ResourceIterable<Node> getAllNodes() {
        this.assertTransactionOpen();
        return () -> {
            Statement statement = this.spi.currentStatement();
            return this.map2nodes(statement.readOperations().nodesGetAll(), statement);
        };
    }

    public ResourceIterable<Relationship> getAllRelationships() {
        this.assertTransactionOpen();
        return () -> {
            final Statement statement = this.spi.currentStatement();
            final PrimitiveLongIterator ids = statement.readOperations().relationshipsGetAll();
            return new PrefetchingResourceIterator<Relationship>(){

                public void close() {
                    statement.close();
                }

                protected Relationship fetchNextOrNull() {
                    return ids.hasNext() ? new RelationshipProxy(GraphDatabaseFacade.this.relActions, ids.next()) : null;
                }
            };
        };
    }

    public ResourceIterable<Label> getAllLabelsInUse() {
        return this.allInUse(TokenAccess.LABELS);
    }

    public ResourceIterable<RelationshipType> getAllRelationshipTypesInUse() {
        return this.allInUse(TokenAccess.RELATIONSHIP_TYPES);
    }

    private <T> ResourceIterable<T> allInUse(TokenAccess<T> tokens) {
        this.assertTransactionOpen();
        return () -> tokens.inUse(this.spi.currentStatement());
    }

    public ResourceIterable<Label> getAllLabels() {
        return this.all(TokenAccess.LABELS);
    }

    public ResourceIterable<RelationshipType> getAllRelationshipTypes() {
        return this.all(TokenAccess.RELATIONSHIP_TYPES);
    }

    public ResourceIterable<String> getAllPropertyKeys() {
        return this.all(TokenAccess.PROPERTY_KEYS);
    }

    private <T> ResourceIterable<T> all(TokenAccess<T> tokens) {
        this.assertTransactionOpen();
        return () -> tokens.all(this.spi.currentStatement());
    }

    public KernelEventHandler registerKernelEventHandler(KernelEventHandler handler) {
        this.spi.registerKernelEventHandler(handler);
        return handler;
    }

    public <T> TransactionEventHandler<T> registerTransactionEventHandler(TransactionEventHandler<T> handler) {
        this.spi.registerTransactionEventHandler(handler);
        return handler;
    }

    public KernelEventHandler unregisterKernelEventHandler(KernelEventHandler handler) {
        this.spi.unregisterKernelEventHandler(handler);
        return handler;
    }

    public <T> TransactionEventHandler<T> unregisterTransactionEventHandler(TransactionEventHandler<T> handler) {
        this.spi.unregisterTransactionEventHandler(handler);
        return handler;
    }

    public ResourceIterator<Node> findNodes(Label myLabel, String key, Object value) {
        return this.nodesByLabelAndProperty(myLabel, key, value);
    }

    public Node findNode(Label myLabel, String key, Object value) {
        try (ResourceIterator<Node> iterator = this.findNodes(myLabel, key, value);){
            if (!iterator.hasNext()) {
                Node node = null;
                return node;
            }
            Node node = (Node)iterator.next();
            if (iterator.hasNext()) {
                throw new MultipleFoundException();
            }
            Node node2 = node;
            return node2;
        }
    }

    public ResourceIterator<Node> findNodes(Label myLabel) {
        return this.allNodesWithLabel(myLabel);
    }

    private ResourceIterator<Node> nodesByLabelAndProperty(Label myLabel, String key, Object value) {
        Statement statement = this.spi.currentStatement();
        ReadOperations readOps = statement.readOperations();
        int propertyId = readOps.propertyKeyGetForName(key);
        int labelId = readOps.labelGetForName(myLabel.name());
        if (propertyId == -1 || labelId == -1) {
            statement.close();
            return Iterators.emptyIterator();
        }
        IndexDescriptor descriptor = this.findAnyIndexByLabelAndProperty(readOps, propertyId, labelId);
        try {
            if (null != descriptor) {
                return this.map2nodes(readOps.nodesGetFromIndexSeek(descriptor, value), statement);
            }
        }
        catch (IndexNotFoundKernelException indexNotFoundKernelException) {
            // empty catch block
        }
        return this.getNodesByLabelAndPropertyWithoutIndex(propertyId, value, statement, labelId);
    }

    private IndexDescriptor findAnyIndexByLabelAndProperty(ReadOperations readOps, int propertyId, int labelId) {
        try {
            IndexDescriptor descriptor = readOps.indexGetForLabelAndPropertyKey(labelId, propertyId);
            if (readOps.indexGetState(descriptor) == InternalIndexState.ONLINE) {
                return descriptor;
            }
        }
        catch (IndexNotFoundKernelException | SchemaRuleNotFoundException kernelException) {
            // empty catch block
        }
        return null;
    }

    private ResourceIterator<Node> getNodesByLabelAndPropertyWithoutIndex(int propertyId, Object value, Statement statement, int labelId) {
        return this.map2nodes((PrimitiveLongIterator)new PropertyValueFilteringNodeIdIterator(statement.readOperations().nodesGetForLabel(labelId), statement.readOperations(), propertyId, value), statement);
    }

    private ResourceIterator<Node> allNodesWithLabel(Label myLabel) {
        Statement statement = this.spi.currentStatement();
        int labelId = statement.readOperations().labelGetForName(myLabel.name());
        if (labelId == -1) {
            statement.close();
            return Iterators.emptyIterator();
        }
        PrimitiveLongIterator nodeIds = statement.readOperations().nodesGetForLabel(labelId);
        return ResourceClosingIterator.newResourceIterator((Resource)statement, (Iterator)PrimitiveLongCollections.map(nodeId -> new NodeProxy(this.nodeActions, nodeId), (PrimitiveLongIterator)nodeIds));
    }

    private ResourceIterator<Node> map2nodes(PrimitiveLongIterator input, Statement statement) {
        return ResourceClosingIterator.newResourceIterator((Resource)statement, (Iterator)PrimitiveLongCollections.map(id -> new NodeProxy(this.nodeActions, id), (PrimitiveLongIterator)input));
    }

    public TraversalDescription traversalDescription() {
        return new MonoDirectionalTraversalDescription(this.spi::currentStatement);
    }

    public BidirectionalTraversalDescription bidirectionalTraversalDescription() {
        return new BidirectionalTraversalDescriptionImpl(this.spi::currentStatement);
    }

    @Override
    public DependencyResolver getDependencyResolver() {
        return this.spi.resolver();
    }

    @Override
    public StoreId storeId() {
        return this.spi.storeId();
    }

    @Override
    public URL validateURLAccess(URL url) throws URLAccessValidationError {
        return this.spi.validateURLAccess(url);
    }

    @Override
    public String getStoreDir() {
        return this.spi.storeDir().getAbsolutePath();
    }

    public String toString() {
        return this.spi.name() + " [" + this.getStoreDir() + "]";
    }

    private void assertTransactionOpen() {
        Status reason = this.spi.currentTransaction().getReasonIfTerminated();
        if (reason != null) {
            throw new TransactionTerminatedException(reason);
        }
    }

    private static class PropertyValueFilteringNodeIdIterator
    extends PrimitiveLongCollections.PrimitiveLongBaseIterator {
        private final PrimitiveLongIterator nodesWithLabel;
        private final ReadOperations statement;
        private final int propertyKeyId;
        private final Object value;

        PropertyValueFilteringNodeIdIterator(PrimitiveLongIterator nodesWithLabel, ReadOperations statement, int propertyKeyId, Object value) {
            this.nodesWithLabel = nodesWithLabel;
            this.statement = statement;
            this.propertyKeyId = propertyKeyId;
            this.value = value;
        }

        protected boolean fetchNext() {
            boolean hasNext = this.nodesWithLabel.hasNext();
            while (hasNext) {
                long nextValue = this.nodesWithLabel.next();
                try {
                    Object propertyValue = this.statement.nodeGetProperty(nextValue, this.propertyKeyId);
                    if (propertyValue != null && Property.property(this.propertyKeyId, propertyValue).valueEquals(this.value)) {
                        return this.next(nextValue);
                    }
                }
                catch (EntityNotFoundException entityNotFoundException) {
                    // empty catch block
                }
                hasNext = this.nodesWithLabel.hasNext();
            }
            return false;
        }
    }

    public static interface SPI {
        public boolean databaseIsAvailable(long var1);

        public DependencyResolver resolver();

        public StoreId storeId();

        public File storeDir();

        public String name();

        public void shutdown();

        public KernelTransaction beginTransaction(KernelTransaction.Type var1, AccessMode var2);

        public KernelTransaction currentTransaction();

        public boolean isInOpenTransaction();

        public Statement currentStatement();

        public Result executeQuery(String var1, Map<String, Object> var2, QuerySession var3);

        public AutoIndexing autoIndexing();

        public void registerKernelEventHandler(KernelEventHandler var1);

        public void unregisterKernelEventHandler(KernelEventHandler var1);

        public <T> void registerTransactionEventHandler(TransactionEventHandler<T> var1);

        public <T> void unregisterTransactionEventHandler(TransactionEventHandler<T> var1);

        public URL validateURLAccess(URL var1) throws URLAccessValidationError;

        public GraphDatabaseQueryService queryService();
    }
}

