/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.StatementTokenNameLookup;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.builtinprocs.AwaitIndexProcedure;
import org.neo4j.kernel.impl.api.TokenAccess;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class BuiltInProcedures {
    @Context
    public KernelTransaction tx;

    @Procedure(name="db.labels", mode=Procedure.Mode.READ)
    public Stream<LabelResult> listLabels() {
        return TokenAccess.LABELS.inUse(this.tx.acquireStatement()).map(x$0 -> new LabelResult((Label)x$0)).stream();
    }

    @Procedure(name="db.propertyKeys", mode=Procedure.Mode.READ)
    public Stream<PropertyKeyResult> listPropertyKeys() {
        return TokenAccess.PROPERTY_KEYS.inUse(this.tx.acquireStatement()).map(x$0 -> new PropertyKeyResult((String)x$0)).stream();
    }

    @Procedure(name="db.relationshipTypes", mode=Procedure.Mode.READ)
    public Stream<RelationshipTypeResult> listRelationshipTypes() {
        return TokenAccess.RELATIONSHIP_TYPES.inUse(this.tx.acquireStatement()).map(x$0 -> new RelationshipTypeResult((RelationshipType)x$0)).stream();
    }

    @Procedure(name="db.indexes", mode=Procedure.Mode.READ)
    public Stream<IndexResult> listIndexes() throws ProcedureException {
        ReadOperations operations = this.tx.acquireStatement().readOperations();
        StatementTokenNameLookup tokens = new StatementTokenNameLookup(operations);
        List indexes = Iterators.asList(operations.indexesGetAll());
        indexes.sort((a, b) -> a.userDescription(tokens).compareTo(b.userDescription(tokens)));
        ArrayList<IndexResult> result = new ArrayList<IndexResult>();
        for (IndexDescriptor index : indexes) {
            try {
                result.add(new IndexResult("INDEX ON " + index.userDescription(tokens), operations.indexGetState(index).toString()));
            }
            catch (IndexNotFoundKernelException e) {
                throw new ProcedureException((Status)Status.Schema.IndexNotFound, (Throwable)e, "No index on ", index.userDescription(tokens));
            }
        }
        return result.stream();
    }

    @Procedure(name="db.awaitIndex", mode=Procedure.Mode.READ)
    public void awaitIndex(@Name(value="label") String labelName, @Name(value="property") String propertyKeyName, @Name(value="timeOutSeconds") long timeout) throws ProcedureException {
        new AwaitIndexProcedure(this.tx).execute(labelName, propertyKeyName, timeout, TimeUnit.SECONDS);
    }

    @Procedure(name="db.constraints", mode=Procedure.Mode.READ)
    public Stream<ConstraintResult> listConstraints() {
        ReadOperations operations = this.tx.acquireStatement().readOperations();
        StatementTokenNameLookup tokens = new StatementTokenNameLookup(operations);
        return Iterators.asList(operations.constraintsGetAll()).stream().map(constraint -> constraint.userDescription(tokens)).sorted().map(x$0 -> new ConstraintResult((String)x$0));
    }

    @Procedure(name="dbms.procedures", mode=Procedure.Mode.READ)
    public Stream<ProcedureResult> listProcedures() {
        return this.tx.acquireStatement().readOperations().proceduresGetAll().stream().sorted((a, b) -> a.name().toString().compareTo(b.name().toString())).map(x$0 -> new ProcedureResult((ProcedureSignature)x$0));
    }

    public class ProcedureResult {
        public final String name;
        public final String signature;

        private ProcedureResult(ProcedureSignature signature) {
            this.name = signature.name().toString();
            this.signature = signature.toString();
        }
    }

    public class ConstraintResult {
        public final String description;

        private ConstraintResult(String description) {
            this.description = description;
        }
    }

    public class IndexResult {
        public final String description;
        public final String state;

        private IndexResult(String description, String state) {
            this.description = description;
            this.state = state;
        }
    }

    public class RelationshipTypeResult {
        public final String relationshipType;

        private RelationshipTypeResult(RelationshipType relationshipType) {
            this.relationshipType = relationshipType.name();
        }
    }

    public class PropertyKeyResult {
        public final String propertyKey;

        private PropertyKeyResult(String propertyKey) {
            this.propertyKey = propertyKey;
        }
    }

    public class LabelResult {
        public final String label;

        private LabelResult(Label label) {
            this.label = label.name();
        }
    }
}

