/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import org.neo4j.helpers.Clock;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;

public class ExecutionSupervisor {
    private final Clock clock;
    private final ExecutionMonitor monitor;

    public ExecutionSupervisor(Clock clock, ExecutionMonitor monitor) {
        this.clock = clock;
        this.monitor = monitor;
    }

    public ExecutionSupervisor(ExecutionMonitor monitor) {
        this(Clock.SYSTEM_CLOCK, monitor);
    }

    public synchronized void supervise(StageExecution ... executions) {
        long startTime = this.currentTimeMillis();
        this.start(executions);
        while (this.anyStillExecuting(executions)) {
            this.finishAwareSleep(executions);
            this.monitor.check(executions);
        }
        this.end(executions, this.currentTimeMillis() - startTime);
    }

    private long currentTimeMillis() {
        return this.clock.currentTimeMillis();
    }

    private boolean anyStillExecuting(StageExecution[] executions) {
        for (StageExecution execution : executions) {
            if (!execution.stillExecuting()) continue;
            return true;
        }
        return false;
    }

    protected void end(StageExecution[] executions, long totalTimeMillis) {
        this.monitor.end(executions, totalTimeMillis);
    }

    protected void start(StageExecution[] executions) {
        this.monitor.start(executions);
    }

    private void finishAwareSleep(StageExecution[] executions) {
        long endTime = this.monitor.nextCheckTime();
        while (this.currentTimeMillis() < endTime && this.anyStillExecuting(executions)) {
            try {
                Thread.sleep(Math.min(10L, Math.max(0L, endTime - this.currentTimeMillis())));
            }
            catch (InterruptedException e) {
                for (StageExecution execution : executions) {
                    execution.panic(e);
                }
            }
        }
    }
}

