/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;

public class RecordIdIteration {
    public static final PrimitiveLongIterator backwards(final long lowIncluded, final long highExcluded) {
        return new PrimitiveLongCollections.PrimitiveLongBaseIterator(){
            private long next;
            {
                this.next = highExcluded - 1L;
            }

            protected boolean fetchNext() {
                return this.next >= lowIncluded ? this.next(this.next--) : false;
            }
        };
    }

    public static final PrimitiveLongIterator forwards(final long lowIncluded, final long highExcluded) {
        return new PrimitiveLongCollections.PrimitiveLongBaseIterator(){
            private long nextId;
            {
                this.nextId = lowIncluded;
            }

            protected boolean fetchNext() {
                return this.nextId < highExcluded ? this.next(this.nextId++) : false;
            }
        };
    }

    public static PrimitiveLongIterator allIn(RecordStore<? extends AbstractBaseRecord> store) {
        return RecordIdIteration.forwards(store.getNumberOfReservedLowIds(), store.getHighId());
    }

    public static PrimitiveLongIterator allInReversed(RecordStore<? extends AbstractBaseRecord> store) {
        return RecordIdIteration.backwards(store.getNumberOfReservedLowIds(), store.getHighId());
    }
}

