/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import java.util.Set;
import java.util.function.Supplier;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.index.AutoIndexer;
import org.neo4j.graphdb.index.ReadableIndex;
import org.neo4j.kernel.api.legacyindex.AutoIndexOperations;

public class AutoIndexerFacade<T extends PropertyContainer>
implements AutoIndexer<T> {
    private final Supplier<ReadableIndex<T>> indexProvider;
    private final AutoIndexOperations autoIndexing;

    public AutoIndexerFacade(Supplier<ReadableIndex<T>> indexProvider, AutoIndexOperations autoIndexing) {
        this.indexProvider = indexProvider;
        this.autoIndexing = autoIndexing;
    }

    public void setEnabled(boolean enabled) {
        this.autoIndexing.enabled(enabled);
    }

    public boolean isEnabled() {
        return this.autoIndexing.enabled();
    }

    public ReadableIndex<T> getAutoIndex() {
        return this.indexProvider.get();
    }

    public void startAutoIndexingProperty(String propName) {
        this.autoIndexing.startAutoIndexingProperty(propName);
    }

    public void stopAutoIndexingProperty(String propName) {
        this.autoIndexing.stopAutoIndexingProperty(propName);
    }

    public Set<String> getAutoIndexedProperties() {
        return this.autoIndexing.getAutoIndexedProperties();
    }
}

