/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.security;

import org.neo4j.kernel.api.security.AccessMode;

public class RestrictedAccessMode
implements AccessMode {
    private final AccessMode originalMode;
    private final AccessMode restrictedMode;

    public RestrictedAccessMode(AccessMode originalMode, AccessMode restrictedMode) {
        this.originalMode = originalMode;
        this.restrictedMode = restrictedMode;
    }

    @Override
    public boolean allowsReads() {
        return this.restrictedMode.allowsReads() && (this.restrictedMode.overrideOriginalMode() || this.originalMode.allowsReads());
    }

    @Override
    public boolean allowsWrites() {
        return this.restrictedMode.allowsWrites() && (this.restrictedMode.overrideOriginalMode() || this.originalMode.allowsWrites());
    }

    @Override
    public boolean allowsSchemaWrites() {
        return this.restrictedMode.allowsSchemaWrites() && (this.restrictedMode.overrideOriginalMode() || this.originalMode.allowsSchemaWrites());
    }

    @Override
    public boolean overrideOriginalMode() {
        return false;
    }

    @Override
    public String name() {
        if (this.restrictedMode.overrideOriginalMode()) {
            return this.originalMode.name() + " overridden by " + this.restrictedMode.name();
        }
        return this.originalMode.name() + " restricted to " + this.restrictedMode.name();
    }
}

