/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.dbms;

import org.neo4j.collection.RawIterator;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.dbms.DbmsOperations;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.api.security.AuthSubject;
import org.neo4j.kernel.impl.proc.Procedures;

public class NonTransactionalDbmsOperations
implements DbmsOperations {
    private final Procedures procedures;
    private final KernelTransaction transaction;

    public NonTransactionalDbmsOperations(Procedures procedures, KernelTransaction transaction) {
        this.procedures = procedures;
        this.transaction = transaction;
    }

    @Override
    public RawIterator<Object[], ProcedureException> procedureCallDbms(ProcedureSignature.ProcedureName name, Object[] input) throws ProcedureException {
        CallableProcedure.BasicContext ctx = new CallableProcedure.BasicContext();
        ctx.put(CallableProcedure.Context.KERNEL_TRANSACTION, this.transaction);
        if (this.transaction.mode() instanceof AuthSubject) {
            AuthSubject subject = (AuthSubject)this.transaction.mode();
            ctx.put(CallableProcedure.Context.AUTH_SUBJECT, subject);
        }
        return this.procedures.call(ctx, name, input);
    }

    public static class Factory
    implements DbmsOperations.Factory {
        private final Procedures procedures;

        public Factory(Procedures procedures) {
            this.procedures = procedures;
        }

        @Override
        public DbmsOperations newInstance(KernelTransaction tx) {
            return new NonTransactionalDbmsOperations(this.procedures, tx);
        }
    }
}

