/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.SchemaWriteOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.TokenWriteOperations;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.txstate.LegacyIndexTransactionState;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.OperationsFacade;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.storageengine.api.StorageStatement;

public class KernelStatement
implements TxStateHolder,
Statement {
    private final TxStateHolder txStateHolder;
    private final StorageStatement storeStatement;
    private final KernelTransactionImplementation transaction;
    private final OperationsFacade facade;
    private Locks.Client locks;
    private int referenceCount;

    public KernelStatement(KernelTransactionImplementation transaction, TxStateHolder txStateHolder, StatementOperationParts operations, StorageStatement storeStatement, Procedures procedures) {
        this.transaction = transaction;
        this.txStateHolder = txStateHolder;
        this.storeStatement = storeStatement;
        this.facade = new OperationsFacade(transaction, this, operations, procedures);
    }

    @Override
    public ReadOperations readOperations() {
        if (!this.transaction.mode().allowsReads()) {
            throw new AuthorizationViolationException(String.format("Read operations are not allowed for '%s'.", this.transaction.mode().name()));
        }
        return this.facade;
    }

    @Override
    public TokenWriteOperations tokenWriteOperations() {
        return this.facade;
    }

    @Override
    public DataWriteOperations dataWriteOperations() throws InvalidTransactionTypeKernelException {
        if (!this.transaction.mode().allowsWrites()) {
            throw new AuthorizationViolationException(String.format("Write operations are not allowed for '%s'.", this.transaction.mode().name()));
        }
        this.transaction.upgradeToDataWrites();
        return this.facade;
    }

    @Override
    public SchemaWriteOperations schemaWriteOperations() throws InvalidTransactionTypeKernelException {
        if (!this.transaction.mode().allowsSchemaWrites()) {
            throw new AuthorizationViolationException(String.format("Schema operations are not allowed for '%s'.", this.transaction.mode().name()));
        }
        this.transaction.upgradeToSchemaWrites();
        return this.facade;
    }

    @Override
    public TransactionState txState() {
        return this.txStateHolder.txState();
    }

    @Override
    public LegacyIndexTransactionState legacyIndexTxState() {
        return this.txStateHolder.legacyIndexTxState();
    }

    @Override
    public boolean hasTxStateWithChanges() {
        return this.txStateHolder.hasTxStateWithChanges();
    }

    public void close() {
        if (this.referenceCount > 0 && --this.referenceCount == 0) {
            this.cleanupResources();
        }
    }

    void assertOpen() {
        if (this.referenceCount == 0) {
            throw new NotInTransactionException("The statement has been closed.");
        }
        Status terminationReason = this.transaction.getReasonIfTerminated();
        if (terminationReason != null) {
            throw new TransactionTerminatedException(terminationReason);
        }
    }

    void initialize(Locks.Client locks) {
        this.locks = locks;
    }

    public Locks.Client locks() {
        return this.locks;
    }

    final void acquire() {
        if (this.referenceCount++ == 0) {
            this.storeStatement.acquire();
        }
    }

    final void forceClose() {
        if (this.referenceCount > 0) {
            this.referenceCount = 0;
            this.cleanupResources();
        }
    }

    private void cleanupResources() {
        this.storeStatement.release();
    }

    public StorageStatement getStoreStatement() {
        return this.storeStatement;
    }
}

