/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.constraints.NodePropertyExistenceConstraint;
import org.neo4j.kernel.api.exceptions.schema.ConstraintVerificationFailedKernelException;

public class NodePropertyExistenceConstraintVerificationFailedKernelException
extends ConstraintVerificationFailedKernelException {
    private final NodePropertyExistenceConstraint constraint;
    private final long nodeId;

    public NodePropertyExistenceConstraintVerificationFailedKernelException(NodePropertyExistenceConstraint constraint, long nodeId) {
        super(constraint);
        this.constraint = constraint;
        this.nodeId = nodeId;
    }

    @Override
    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        return String.format("Node(%s) with label `%s` has no value for property `%s`", this.nodeId, tokenNameLookup.labelGetName(this.constraint.label()), tokenNameLookup.propertyKeyGetName(this.constraint.propertyKey()));
    }

    @Override
    public NodePropertyExistenceConstraint constraint() {
        return this.constraint;
    }
}

