/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.util.List;
import org.neo4j.collection.RawIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.StatementTokenNameLookup;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.api.proc.Neo4jTypes;
import org.neo4j.kernel.api.proc.ProcedureSignature;

public class ListIndexesProcedure
extends CallableProcedure.BasicProcedure {
    protected ListIndexesProcedure(ProcedureSignature.ProcedureName procedureName) {
        super(ProcedureSignature.procedureSignature(procedureName).out("description", Neo4jTypes.NTString).out("state", Neo4jTypes.NTString).build());
    }

    @Override
    public RawIterator<Object[], ProcedureException> apply(CallableProcedure.Context ctx, Object[] input) throws ProcedureException {
        Statement statement = ctx.get(CallableProcedure.Context.KERNEL_TRANSACTION).acquireStatement();
        StatementTokenNameLookup tokens = new StatementTokenNameLookup(statement.readOperations());
        List indexes = Iterators.asList(statement.readOperations().indexesGetAll());
        indexes.sort((a, b) -> a.userDescription(tokens).compareTo(b.userDescription(tokens)));
        return Iterators.map(index -> {
            try {
                return new Object[]{"INDEX ON " + index.userDescription(tokens), statement.readOperations().indexGetState((IndexDescriptor)index).toString()};
            }
            catch (IndexNotFoundKernelException e) {
                throw new ProcedureException((Status)Status.Schema.IndexNotFound, (Throwable)e, "No index on ", index.userDescription(tokens));
            }
        }, (RawIterator)Iterators.asRawIterator(indexes.iterator()));
    }
}

