/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.util.concurrent.TimeUnit;
import org.neo4j.helpers.Clock;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;

public interface ExecutionMonitor {
    public void start(StageExecution var1);

    public void end(StageExecution var1, long var2);

    public void done(long var1, String var3);

    public long nextCheckTime();

    public void check(StageExecution var1);

    public static abstract class Adapter
    implements ExecutionMonitor {
        private final Clock clock;
        private final long intervalMillis;

        public Adapter(Clock clock, long time, TimeUnit unit) {
            this.clock = clock;
            this.intervalMillis = unit.toMillis(time);
        }

        public Adapter(long time, TimeUnit unit) {
            this(Clock.SYSTEM_CLOCK, time, unit);
        }

        @Override
        public long nextCheckTime() {
            return this.clock.currentTimeMillis() + this.intervalMillis;
        }

        @Override
        public void start(StageExecution execution) {
        }

        @Override
        public void end(StageExecution execution, long totalTimeMillis) {
        }

        @Override
        public void done(long totalTimeMillis, String additionalInformation) {
        }
    }
}

