/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Format;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.unsafe.impl.batchimport.AdditionalInitialIds;
import org.neo4j.unsafe.impl.batchimport.BatchImporter;
import org.neo4j.unsafe.impl.batchimport.BatchInsertRelationshipsStage;
import org.neo4j.unsafe.impl.batchimport.CalculateDenseNodesStage;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.CountingStoreUpdateMonitor;
import org.neo4j.unsafe.impl.batchimport.DeleteDuplicateNodesStage;
import org.neo4j.unsafe.impl.batchimport.IdMapperPreparationStage;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.MemoryUsageStatsProvider;
import org.neo4j.unsafe.impl.batchimport.NodeCountsStage;
import org.neo4j.unsafe.impl.batchimport.NodeFirstRelationshipStage;
import org.neo4j.unsafe.impl.batchimport.NodeStage;
import org.neo4j.unsafe.impl.batchimport.RelationshipCountsStage;
import org.neo4j.unsafe.impl.batchimport.RelationshipGroupDefragmenter;
import org.neo4j.unsafe.impl.batchimport.RelationshipLinkbackStage;
import org.neo4j.unsafe.impl.batchimport.RelationshipStage;
import org.neo4j.unsafe.impl.batchimport.SourceOrCachedInputIterable;
import org.neo4j.unsafe.impl.batchimport.cache.GatheringMemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.NodeLabelsCache;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipCache;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdGenerator;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.input.InputCache;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.input.PerTypeRelationshipSplitter;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionSupervisors;
import org.neo4j.unsafe.impl.batchimport.staging.Stage;
import org.neo4j.unsafe.impl.batchimport.store.BatchingNeoStores;
import org.neo4j.unsafe.impl.batchimport.store.io.IoMonitor;

public class ParallelBatchImporter
implements BatchImporter {
    private final File storeDir;
    private final FileSystemAbstraction fileSystem;
    private final Configuration config;
    private final LogService logService;
    private final Log log;
    private final ExecutionMonitor executionMonitor;
    private final AdditionalInitialIds additionalInitialIds;
    private final Config dbConfig;

    public ParallelBatchImporter(File storeDir, FileSystemAbstraction fileSystem, Configuration config, LogService logService, ExecutionMonitor executionMonitor, AdditionalInitialIds additionalInitialIds, Config dbConfig) {
        this.storeDir = storeDir;
        this.fileSystem = fileSystem;
        this.config = config;
        this.logService = logService;
        this.dbConfig = dbConfig;
        this.log = logService.getInternalLogProvider().getLog(this.getClass());
        this.executionMonitor = executionMonitor;
        this.additionalInitialIds = additionalInitialIds;
    }

    public ParallelBatchImporter(File storeDir, Configuration config, LogService logService, ExecutionMonitor executionMonitor, Config dbConfig) {
        this(storeDir, (FileSystemAbstraction)new DefaultFileSystemAbstraction(), config, logService, ExecutionSupervisors.withDynamicProcessorAssignment(executionMonitor, config), AdditionalInitialIds.EMPTY, dbConfig);
    }

    @Override
    public void doImport(Input input) throws IOException {
        this.log.info("Import starting");
        NodeRelationshipCache nodeRelationshipCache = null;
        NodeLabelsCache nodeLabelsCache = null;
        long startTime = System.currentTimeMillis();
        CountingStoreUpdateMonitor storeUpdateMonitor = new CountingStoreUpdateMonitor();
        RecordFormats recordFormats = RecordFormatSelector.selectForConfig(this.dbConfig, (LogProvider)NullLogProvider.getInstance());
        try (BatchingNeoStores neoStore = new BatchingNeoStores(this.fileSystem, this.storeDir, recordFormats, this.config, this.logService, this.additionalInitialIds, this.dbConfig);
             CountsAccessor.Updater countsUpdater = neoStore.getCountsStore().reset(neoStore.getLastCommittedTransactionId());
             InputCache inputCache = new InputCache(this.fileSystem, this.storeDir, recordFormats, this.config);){
            Collector badCollector = input.badCollector();
            IoMonitor writeMonitor = new IoMonitor(neoStore.getIoTracer());
            IdMapper idMapper = input.idMapper();
            IdGenerator idGenerator = input.idGenerator();
            nodeRelationshipCache = new NodeRelationshipCache(NumberArrayFactory.AUTO, this.config.denseNodeThreshold());
            MemoryUsageStatsProvider memoryUsageStats = new MemoryUsageStatsProvider(nodeRelationshipCache, idMapper);
            InputIterable<InputNode> nodes = input.nodes();
            InputIterable<InputRelationship> relationships = input.relationships();
            InputIterable<InputNode> cachedNodes = SourceOrCachedInputIterable.cachedForSure(nodes, inputCache.nodes("main", true));
            InputIterable<InputRelationship> cachedRelationships = SourceOrCachedInputIterable.cachedForSure(relationships, inputCache.relationships("main", true));
            RelationshipStore relationshipStore = neoStore.getRelationshipStore();
            NodeStage nodeStage = new NodeStage(this.config, writeMonitor, nodes, idMapper, idGenerator, neoStore, inputCache, neoStore.getLabelScanStore(), storeUpdateMonitor, nodeRelationshipCache, memoryUsageStats);
            this.executeStage(nodeStage);
            if (idMapper.needsPreparation()) {
                this.executeStage(new IdMapperPreparationStage(this.config, idMapper, cachedNodes, badCollector, memoryUsageStats));
                PrimitiveLongIterator duplicateNodeIds = badCollector.leftOverDuplicateNodesIds();
                if (duplicateNodeIds.hasNext()) {
                    this.executeStage(new DeleteDuplicateNodesStage(this.config, duplicateNodeIds, neoStore));
                }
            }
            CalculateDenseNodesStage calculateDenseNodesStage = new CalculateDenseNodesStage(Configuration.withBatchSize(this.config, this.config.batchSize() * 10), relationships, nodeRelationshipCache, idMapper, badCollector, inputCache, neoStore);
            this.executeStage(calculateDenseNodesStage);
            this.importRelationships(nodeRelationshipCache, storeUpdateMonitor, neoStore, writeMonitor, idMapper, cachedRelationships, inputCache, calculateDenseNodesStage.getRelationshipTypes(Long.MAX_VALUE), calculateDenseNodesStage.getRelationshipTypes(100L));
            long peakMemoryUsage = this.totalMemoryUsageOf(idMapper, nodeRelationshipCache);
            long highNodeId = nodeRelationshipCache.getHighNodeId();
            idMapper.close();
            idMapper = null;
            nodeRelationshipCache.close();
            nodeRelationshipCache = null;
            new RelationshipGroupDefragmenter(this.config, this.executionMonitor).run(Math.max(Math.max(peakMemoryUsage, highNodeId * 4L), ByteUnit.mebiBytes((long)1L)), neoStore, highNodeId);
            nodeLabelsCache = new NodeLabelsCache(NumberArrayFactory.AUTO, neoStore.getLabelRepository().getHighId());
            memoryUsageStats = new MemoryUsageStatsProvider(nodeLabelsCache);
            this.executeStage(new NodeCountsStage(this.config, nodeLabelsCache, neoStore.getNodeStore(), neoStore.getLabelRepository().getHighId(), countsUpdater, memoryUsageStats));
            this.executeStage(new RelationshipCountsStage(this.config, nodeLabelsCache, relationshipStore, neoStore.getLabelRepository().getHighId(), neoStore.getRelationshipTypeRepository().getHighId(), countsUpdater, NumberArrayFactory.AUTO));
            long totalTimeMillis = System.currentTimeMillis() - startTime;
            this.executionMonitor.done(totalTimeMillis, String.format("%n", new Object[0]) + storeUpdateMonitor.toString() + String.format("%n", new Object[0]) + "Peak memory usage: " + Format.bytes(peakMemoryUsage));
            this.log.info("Import completed, took " + Format.duration(totalTimeMillis) + ". " + storeUpdateMonitor);
        }
        catch (Throwable t) {
            this.log.error("Error during import", t);
            throw Exceptions.launderedException(IOException.class, t);
        }
        finally {
            if (nodeRelationshipCache != null) {
                nodeRelationshipCache.close();
            }
            if (nodeLabelsCache != null) {
                nodeLabelsCache.close();
            }
        }
    }

    private long totalMemoryUsageOf(MemoryStatsVisitor.Visitable ... users) {
        GatheringMemoryStatsVisitor total = new GatheringMemoryStatsVisitor();
        for (MemoryStatsVisitor.Visitable user : users) {
            user.acceptMemoryStatsVisitor(total);
        }
        return total.getHeapUsage() + total.getOffHeapUsage();
    }

    private void importRelationships(NodeRelationshipCache nodeRelationshipCache, CountingStoreUpdateMonitor storeUpdateMonitor, BatchingNeoStores neoStore, IoMonitor writeMonitor, IdMapper idMapper, InputIterable<InputRelationship> relationships, InputCache inputCache, Object[] allRelationshipTypes, Object[] minorityRelationshipTypes) {
        Set minorityRelationshipTypeSet = Iterators.asSet((Object[])minorityRelationshipTypes);
        PerTypeRelationshipSplitter perTypeIterator = new PerTypeRelationshipSplitter((InputIterator<InputRelationship>)relationships.iterator(), allRelationshipTypes, type -> minorityRelationshipTypeSet.contains(type), neoStore.getRelationshipTypeRepository(), inputCache);
        long nextRelationshipId = 0L;
        Configuration relationshipConfig = Configuration.withBatchSize(this.config, neoStore.getRelationshipStore().getRecordsPerPage());
        Configuration nodeConfig = Configuration.withBatchSize(this.config, neoStore.getNodeStore().getRecordsPerPage());
        int i = 0;
        while (perTypeIterator.hasNext()) {
            nodeRelationshipCache.setForwardScan(true);
            Object currentType = perTypeIterator.currentType();
            int currentTypeId = neoStore.getRelationshipTypeRepository().getOrCreateId(currentType);
            InputIterator perType = (InputIterator)perTypeIterator.next();
            String topic = " [:" + currentType + "] (" + (i + 1) + "/" + allRelationshipTypes.length + ")";
            RelationshipStage relationshipStage = new RelationshipStage(topic, this.config, writeMonitor, perType, idMapper, neoStore, nodeRelationshipCache, storeUpdateMonitor, nextRelationshipId);
            this.executeStage(relationshipStage);
            this.executeStage(new NodeFirstRelationshipStage(topic, nodeConfig, neoStore.getNodeStore(), neoStore.getTemporaryRelationshipGroupStore(), nodeRelationshipCache, true, currentTypeId));
            nodeRelationshipCache.setForwardScan(false);
            this.executeStage(new RelationshipLinkbackStage(topic, relationshipConfig, neoStore.getRelationshipStore(), nodeRelationshipCache, nextRelationshipId, relationshipStage.getNextRelationshipId(), true));
            nextRelationshipId = relationshipStage.getNextRelationshipId();
            nodeRelationshipCache.clearChangedChunks(true);
            ++i;
        }
        String topic = " Sparse";
        nodeRelationshipCache.setForwardScan(true);
        this.executeStage(new NodeFirstRelationshipStage(topic, nodeConfig, neoStore.getNodeStore(), neoStore.getTemporaryRelationshipGroupStore(), nodeRelationshipCache, false, -1));
        nodeRelationshipCache.setForwardScan(false);
        this.executeStage(new RelationshipLinkbackStage(topic, relationshipConfig, neoStore.getRelationshipStore(), nodeRelationshipCache, 0L, nextRelationshipId, false));
        if (minorityRelationshipTypes.length > 0) {
            this.executeStage(new BatchInsertRelationshipsStage(this.config, idMapper, perTypeIterator.getMinorityRelationships(), neoStore, nextRelationshipId));
        }
    }

    private void executeStage(Stage stage) {
        ExecutionSupervisors.superviseExecution(this.executionMonitor, this.config, stage);
    }
}

