/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import java.util.Iterator;
import java.util.function.Function;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.CharSeekers;
import org.neo4j.helpers.collection.NestingIterator;
import org.neo4j.kernel.impl.util.Validator;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.csv.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.csv.Data;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactory;
import org.neo4j.unsafe.impl.batchimport.input.csv.Header;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;
import org.neo4j.unsafe.impl.batchimport.input.csv.InputEntityDeserializer;
import org.neo4j.unsafe.impl.batchimport.input.csv.ParallelInputEntityDeserializer;

class InputGroupsDeserializer<ENTITY extends InputEntity>
extends NestingIterator<ENTITY, DataFactory<ENTITY>>
implements InputIterator<ENTITY> {
    private final Header.Factory headerFactory;
    private final Configuration config;
    private final IdType idType;
    private InputIterator<ENTITY> currentInput = new InputIterator.Empty<ENTITY>();
    private long previousInputsCollectivePositions;
    private int previousInputProcessors = 1;
    private boolean currentInputOpen;
    private final int maxProcessors;
    private final DeserializerFactory<ENTITY> factory;
    private final Validator<ENTITY> validator;
    private final Class<ENTITY> entityClass;

    InputGroupsDeserializer(Iterator<DataFactory<ENTITY>> dataFactory, Header.Factory headerFactory, Configuration config, IdType idType, int maxProcessors, DeserializerFactory<ENTITY> factory, Validator<ENTITY> validator, Class<ENTITY> entityClass) {
        super(dataFactory);
        this.headerFactory = headerFactory;
        this.config = config;
        this.idType = idType;
        this.maxProcessors = maxProcessors;
        this.factory = factory;
        this.validator = validator;
        this.entityClass = entityClass;
    }

    protected InputIterator<ENTITY> createNestedIterator(DataFactory<ENTITY> dataFactory) {
        this.closeCurrent();
        Data<ENTITY> data = dataFactory.create(this.config);
        if (this.config.multilineFields()) {
            CharSeeker dataStream = CharSeekers.charSeeker((CharReadable)data.stream(), (org.neo4j.csv.reader.Configuration)this.config, (boolean)true);
            Header dataHeader = this.headerFactory.create(dataStream, this.config, this.idType);
            InputEntityDeserializer<ENTITY> input = this.factory.create(dataHeader, dataStream, data.decorator(), this.validator);
            this.currentInput = input;
            this.currentInputOpen = true;
            input.initialize();
        } else {
            this.currentInput = new ParallelInputEntityDeserializer<ENTITY>(data, this.headerFactory, this.config, this.idType, this.maxProcessors, this.factory, this.validator, this.entityClass);
            this.currentInput.processors(this.previousInputProcessors);
            this.currentInputOpen = true;
        }
        return this.currentInput;
    }

    private void closeCurrent() {
        if (this.currentInputOpen) {
            this.previousInputsCollectivePositions += this.currentInput.position();
            this.previousInputProcessors = this.currentInput.processors(0);
            this.currentInput.close();
            this.currentInputOpen = false;
        }
    }

    public void close() {
        this.closeCurrent();
    }

    public long position() {
        return this.previousInputsCollectivePositions + this.currentInput.position();
    }

    public String sourceDescription() {
        return this.currentInput.sourceDescription();
    }

    public long lineNumber() {
        return this.currentInput.lineNumber();
    }

    @Override
    public int processors(int delta) {
        return this.currentInput.processors(delta);
    }

    @FunctionalInterface
    public static interface DeserializerFactory<ENTITY extends InputEntity> {
        public InputEntityDeserializer<ENTITY> create(Header var1, CharSeeker var2, Function<ENTITY, ENTITY> var3, Validator<ENTITY> var4);
    }
}

