/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.InvalidTransactionTypeException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.index.IndexPopulationProgress;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.StatementTokenNameLookup;
import org.neo4j.kernel.api.constraints.NodePropertyConstraint;
import org.neo4j.kernel.api.constraints.NodePropertyExistenceConstraint;
import org.neo4j.kernel.api.constraints.PropertyConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyExistenceConstraint;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyIndexedException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.impl.coreapi.schema.BaseNodeConstraintCreator;
import org.neo4j.kernel.impl.coreapi.schema.IndexCreatorImpl;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;
import org.neo4j.kernel.impl.coreapi.schema.NodePropertyExistenceConstraintDefinition;
import org.neo4j.kernel.impl.coreapi.schema.RelationshipPropertyExistenceConstraintDefinition;
import org.neo4j.kernel.impl.coreapi.schema.UniquenessConstraintDefinition;
import org.neo4j.storageengine.api.schema.PopulationProgress;

public class SchemaImpl
implements Schema {
    private final Supplier<Statement> statementContextSupplier;
    private final InternalSchemaActions actions;

    public SchemaImpl(Supplier<Statement> statementContextSupplier) {
        this.statementContextSupplier = statementContextSupplier;
        this.actions = new GDBSchemaActions(statementContextSupplier);
    }

    public IndexCreator indexFor(Label label) {
        return new IndexCreatorImpl(this.actions, label);
    }

    public Iterable<IndexDefinition> getIndexes(Label label) {
        try (Statement statement = this.statementContextSupplier.get();){
            ArrayList<IndexDefinition> definitions = new ArrayList<IndexDefinition>();
            int labelId = statement.readOperations().labelGetForName(label.name());
            if (labelId == -1) {
                List<IndexDefinition> list = Collections.emptyList();
                return list;
            }
            this.addDefinitions(definitions, statement.readOperations(), statement.readOperations().indexesGetForLabel(labelId), false);
            this.addDefinitions(definitions, statement.readOperations(), statement.readOperations().uniqueIndexesGetForLabel(labelId), true);
            ArrayList<IndexDefinition> arrayList = definitions;
            return arrayList;
        }
    }

    public Iterable<IndexDefinition> getIndexes() {
        try (Statement statement = this.statementContextSupplier.get();){
            ArrayList<IndexDefinition> definitions = new ArrayList<IndexDefinition>();
            this.addDefinitions(definitions, statement.readOperations(), statement.readOperations().indexesGetAll(), false);
            this.addDefinitions(definitions, statement.readOperations(), statement.readOperations().uniqueIndexesGetAll(), true);
            ArrayList<IndexDefinition> arrayList = definitions;
            return arrayList;
        }
    }

    private void addDefinitions(List<IndexDefinition> definitions, ReadOperations statement, Iterator<IndexDescriptor> indexes, boolean constraintIndex) {
        Iterators.addToCollection((Iterator)Iterators.map(rule -> {
            try {
                Label label = Label.label((String)statement.labelGetName(rule.getLabelId()));
                String propertyKey = statement.propertyKeyGetName(rule.getPropertyKeyId());
                return new IndexDefinitionImpl(this.actions, label, propertyKey, constraintIndex);
            }
            catch (LabelNotFoundKernelException | PropertyKeyIdNotFoundKernelException e) {
                throw new RuntimeException(e);
            }
        }, indexes), definitions);
    }

    public void awaitIndexOnline(IndexDefinition index, long duration, TimeUnit unit) {
        this.actions.assertInOpenTransaction();
        long timeout = System.currentTimeMillis() + unit.toMillis(duration);
        do {
            Schema.IndexState state = this.getIndexState(index);
            switch (state) {
                case ONLINE: {
                    return;
                }
                case FAILED: {
                    throw new IllegalStateException("Index entered a FAILED state. Please see database logs.");
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (System.currentTimeMillis() < timeout);
        throw new IllegalStateException("Expected index to come online within a reasonable time.");
    }

    public void awaitIndexesOnline(long duration, TimeUnit unit) {
        this.actions.assertInOpenTransaction();
        long millisLeft = TimeUnit.MILLISECONDS.convert(duration, unit);
        ArrayList<IndexDefinition> onlineIndexes = new ArrayList<IndexDefinition>();
        Iterator<IndexDefinition> iter = this.getIndexes().iterator();
        while (iter.hasNext()) {
            if (millisLeft < 0L) {
                throw new IllegalStateException("Expected all indexes to come online within a reasonable time.Indexes brought online: " + onlineIndexes + ". Indexes not guaranteed to be online: " + Iterators.asCollection(iter));
            }
            IndexDefinition index = iter.next();
            long millisBefore = System.currentTimeMillis();
            this.awaitIndexOnline(index, millisLeft, TimeUnit.MILLISECONDS);
            millisLeft -= System.currentTimeMillis() - millisBefore;
            onlineIndexes.add(index);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Schema.IndexState getIndexState(IndexDefinition index) {
        this.actions.assertInOpenTransaction();
        String propertyKey = (String)Iterables.single((Iterable)index.getPropertyKeys());
        try (Statement statement = this.statementContextSupplier.get();){
            int labelId = statement.readOperations().labelGetForName(index.getLabel().name());
            int propertyKeyId = statement.readOperations().propertyKeyGetForName(propertyKey);
            if (labelId == -1) {
                throw new NotFoundException(String.format("Label %s not found", index.getLabel().name()));
            }
            if (propertyKeyId == -1) {
                throw new NotFoundException(String.format("Property key %s not found", propertyKey));
            }
            IndexDescriptor descriptor = statement.readOperations().indexGetForLabelAndPropertyKey(labelId, propertyKeyId);
            InternalIndexState indexState = statement.readOperations().indexGetState(descriptor);
            switch (indexState) {
                case POPULATING: {
                    Schema.IndexState indexState2 = Schema.IndexState.POPULATING;
                    return indexState2;
                }
                case ONLINE: {
                    Schema.IndexState indexState3 = Schema.IndexState.ONLINE;
                    return indexState3;
                }
                case FAILED: {
                    Schema.IndexState indexState4 = Schema.IndexState.FAILED;
                    return indexState4;
                }
            }
            throw new IllegalArgumentException(String.format("Illegal index state %s", new Object[]{indexState}));
        }
        catch (IndexNotFoundKernelException | SchemaRuleNotFoundException e) {
            throw new NotFoundException(String.format("No index for label %s on property %s", index.getLabel().name(), propertyKey));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IndexPopulationProgress getIndexPopulationProgress(IndexDefinition index) {
        this.actions.assertInOpenTransaction();
        String propertyKey = (String)Iterables.single((Iterable)index.getPropertyKeys());
        try (Statement statement = this.statementContextSupplier.get();){
            int labelId = statement.readOperations().labelGetForName(index.getLabel().name());
            int propertyKeyId = statement.readOperations().propertyKeyGetForName(propertyKey);
            if (labelId == -1) {
                throw new NotFoundException(String.format("Label %s not found", index.getLabel().name()));
            }
            if (propertyKeyId == -1) {
                throw new NotFoundException(String.format("Property key %s not found", propertyKey));
            }
            IndexDescriptor descriptor = statement.readOperations().indexGetForLabelAndPropertyKey(labelId, propertyKeyId);
            PopulationProgress progress = statement.readOperations().indexGetPopulationProgress(descriptor);
            IndexPopulationProgress indexPopulationProgress = new IndexPopulationProgress(progress.getCompleted(), progress.getTotal());
            return indexPopulationProgress;
        }
        catch (IndexNotFoundKernelException | SchemaRuleNotFoundException e) {
            throw new NotFoundException(String.format("No index for label %s on property %s", index.getLabel().name(), propertyKey));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getIndexFailure(IndexDefinition index) {
        this.actions.assertInOpenTransaction();
        String propertyKey = (String)Iterables.single((Iterable)index.getPropertyKeys());
        try (Statement statement = this.statementContextSupplier.get();){
            int labelId = statement.readOperations().labelGetForName(index.getLabel().name());
            int propertyKeyId = statement.readOperations().propertyKeyGetForName(propertyKey);
            if (labelId == -1) {
                throw new NotFoundException(String.format("Label %s not found", index.getLabel().name()));
            }
            if (propertyKeyId == -1) {
                throw new NotFoundException(String.format("Property key %s not found", propertyKey));
            }
            IndexDescriptor indexId = statement.readOperations().indexGetForLabelAndPropertyKey(labelId, propertyKeyId);
            String string = statement.readOperations().indexGetFailure(indexId);
            return string;
        }
        catch (IndexNotFoundKernelException | SchemaRuleNotFoundException e) {
            throw new NotFoundException(String.format("No index for label %s on property %s", index.getLabel().name(), propertyKey));
        }
    }

    public ConstraintCreator constraintFor(Label label) {
        this.actions.assertInOpenTransaction();
        return new BaseNodeConstraintCreator(this.actions, label);
    }

    public Iterable<ConstraintDefinition> getConstraints() {
        this.actions.assertInOpenTransaction();
        try (Statement statement = this.statementContextSupplier.get();){
            Iterator<PropertyConstraint> constraints = statement.readOperations().constraintsGetAll();
            Iterable<ConstraintDefinition> iterable = this.asConstraintDefinitions(constraints, statement.readOperations());
            return iterable;
        }
    }

    public Iterable<ConstraintDefinition> getConstraints(Label label) {
        this.actions.assertInOpenTransaction();
        try (Statement statement = this.statementContextSupplier.get();){
            int labelId = statement.readOperations().labelGetForName(label.name());
            if (labelId == -1) {
                List<ConstraintDefinition> list = Collections.emptyList();
                return list;
            }
            Iterator<NodePropertyConstraint> constraints = statement.readOperations().constraintsGetForLabel(labelId);
            Iterable<ConstraintDefinition> iterable = this.asConstraintDefinitions(constraints, statement.readOperations());
            return iterable;
        }
    }

    public Iterable<ConstraintDefinition> getConstraints(RelationshipType type) {
        this.actions.assertInOpenTransaction();
        try (Statement statement = this.statementContextSupplier.get();){
            int typeId = statement.readOperations().relationshipTypeGetForName(type.name());
            if (typeId == -1) {
                List<ConstraintDefinition> list = Collections.emptyList();
                return list;
            }
            Iterator<RelationshipPropertyConstraint> constraints = statement.readOperations().constraintsGetForRelationshipType(typeId);
            Iterable<ConstraintDefinition> iterable = this.asConstraintDefinitions(constraints, statement.readOperations());
            return iterable;
        }
    }

    private Iterable<ConstraintDefinition> asConstraintDefinitions(Iterator<? extends PropertyConstraint> constraints, ReadOperations readOperations) {
        ArrayList<ConstraintDefinition> definitions = new ArrayList<ConstraintDefinition>();
        while (constraints.hasNext()) {
            PropertyConstraint constraint = constraints.next();
            definitions.add(this.asConstraintDefinition(constraint, readOperations));
        }
        return definitions;
    }

    private ConstraintDefinition asConstraintDefinition(PropertyConstraint constraint, ReadOperations readOperations) {
        if (constraint instanceof NodePropertyExistenceConstraint) {
            StatementTokenNameLookup lookup = new StatementTokenNameLookup(readOperations);
            return new NodePropertyExistenceConstraintDefinition(this.actions, Label.label((String)lookup.labelGetName(((NodePropertyConstraint)constraint).label())), lookup.propertyKeyGetName(constraint.propertyKey()));
        }
        if (constraint instanceof UniquenessConstraint) {
            StatementTokenNameLookup lookup = new StatementTokenNameLookup(readOperations);
            return new UniquenessConstraintDefinition(this.actions, Label.label((String)lookup.labelGetName(((NodePropertyConstraint)constraint).label())), lookup.propertyKeyGetName(constraint.propertyKey()));
        }
        if (constraint instanceof RelationshipPropertyExistenceConstraint) {
            StatementTokenNameLookup lookup = new StatementTokenNameLookup(readOperations);
            return new RelationshipPropertyExistenceConstraintDefinition(this.actions, RelationshipType.withName((String)lookup.relationshipTypeGetName(((RelationshipPropertyConstraint)constraint).relationshipType())), lookup.propertyKeyGetName(constraint.propertyKey()));
        }
        throw new IllegalArgumentException("Unknown constraint " + constraint);
    }

    private static class GDBSchemaActions
    implements InternalSchemaActions {
        private final Supplier<Statement> ctxSupplier;

        public GDBSchemaActions(Supplier<Statement> ctxSupplier) {
            this.ctxSupplier = ctxSupplier;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public IndexDefinition createIndexDefinition(Label label, String propertyKey) {
            Throwable throwable = null;
            try (Statement statement = this.ctxSupplier.get();){
                int labelId = statement.schemaWriteOperations().labelGetOrCreateForName(label.name());
                int propertyKeyId = statement.schemaWriteOperations().propertyKeyGetOrCreateForName(propertyKey);
                statement.schemaWriteOperations().indexCreate(labelId, propertyKeyId);
                IndexDefinitionImpl indexDefinitionImpl = new IndexDefinitionImpl(this, label, propertyKey, false);
                return indexDefinitionImpl;
            }
            catch (AlreadyConstrainedException | AlreadyIndexedException e) {
                try {
                    throw new ConstraintViolationException(e.getUserMessage(new StatementTokenNameLookup(statement.readOperations())), (Throwable)e);
                    catch (IllegalTokenNameException e2) {
                        throw new IllegalArgumentException(e2);
                    }
                    catch (TooManyLabelsException e3) {
                        throw new IllegalStateException(e3);
                    }
                    catch (InvalidTransactionTypeKernelException e4) {
                        throw new ConstraintViolationException(e4.getMessage(), (Throwable)e4);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }

        @Override
        public void dropIndexDefinitions(Label label, String propertyKey) {
            try (Statement statement = this.ctxSupplier.get();){
                try {
                    int labelId = statement.readOperations().labelGetForName(label.name());
                    int propertyKeyId = statement.readOperations().propertyKeyGetForName(propertyKey);
                    if (labelId != -1 && propertyKeyId != -1) {
                        statement.schemaWriteOperations().indexDrop(statement.readOperations().indexGetForLabelAndPropertyKey(labelId, propertyKeyId));
                    }
                }
                catch (DropIndexFailureException | SchemaRuleNotFoundException e) {
                    throw new ConstraintViolationException(e.getUserMessage(new StatementTokenNameLookup(statement.readOperations())));
                }
                catch (InvalidTransactionTypeKernelException e) {
                    throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
                }
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public ConstraintDefinition createPropertyUniquenessConstraint(Label label, String propertyKey) {
            Throwable throwable = null;
            try (Statement statement = this.ctxSupplier.get();){
                int labelId = statement.schemaWriteOperations().labelGetOrCreateForName(label.name());
                int propertyKeyId = statement.schemaWriteOperations().propertyKeyGetOrCreateForName(propertyKey);
                statement.schemaWriteOperations().uniquePropertyConstraintCreate(labelId, propertyKeyId);
                UniquenessConstraintDefinition uniquenessConstraintDefinition = new UniquenessConstraintDefinition(this, label, propertyKey);
                return uniquenessConstraintDefinition;
            }
            catch (AlreadyConstrainedException | AlreadyIndexedException | CreateConstraintFailureException e) {
                try {
                    throw new ConstraintViolationException(e.getUserMessage(new StatementTokenNameLookup(statement.readOperations())), (Throwable)e);
                    catch (IllegalTokenNameException e2) {
                        throw new IllegalArgumentException(e2);
                    }
                    catch (TooManyLabelsException e3) {
                        throw new IllegalStateException(e3);
                    }
                    catch (InvalidTransactionTypeKernelException e4) {
                        throw new InvalidTransactionTypeException(e4.getMessage(), (Throwable)e4);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public ConstraintDefinition createPropertyExistenceConstraint(Label label, String propertyKey) {
            Throwable throwable = null;
            try (Statement statement = this.ctxSupplier.get();){
                int labelId = statement.schemaWriteOperations().labelGetOrCreateForName(label.name());
                int propertyKeyId = statement.schemaWriteOperations().propertyKeyGetOrCreateForName(propertyKey);
                statement.schemaWriteOperations().nodePropertyExistenceConstraintCreate(labelId, propertyKeyId);
                NodePropertyExistenceConstraintDefinition nodePropertyExistenceConstraintDefinition = new NodePropertyExistenceConstraintDefinition(this, label, propertyKey);
                return nodePropertyExistenceConstraintDefinition;
            }
            catch (AlreadyConstrainedException | CreateConstraintFailureException e) {
                try {
                    throw new ConstraintViolationException(e.getUserMessage(new StatementTokenNameLookup(statement.readOperations())), (Throwable)e);
                    catch (IllegalTokenNameException e2) {
                        throw new IllegalArgumentException(e2);
                    }
                    catch (TooManyLabelsException e3) {
                        throw new IllegalStateException(e3);
                    }
                    catch (InvalidTransactionTypeKernelException e4) {
                        throw new InvalidTransactionTypeException(e4.getMessage(), (Throwable)e4);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public ConstraintDefinition createPropertyExistenceConstraint(RelationshipType type, String propertyKey) throws CreateConstraintFailureException, AlreadyConstrainedException {
            Throwable throwable = null;
            try (Statement statement = this.ctxSupplier.get();){
                int typeId = statement.schemaWriteOperations().relationshipTypeGetOrCreateForName(type.name());
                int propertyKeyId = statement.schemaWriteOperations().propertyKeyGetOrCreateForName(propertyKey);
                statement.schemaWriteOperations().relationshipPropertyExistenceConstraintCreate(typeId, propertyKeyId);
                RelationshipPropertyExistenceConstraintDefinition relationshipPropertyExistenceConstraintDefinition = new RelationshipPropertyExistenceConstraintDefinition(this, type, propertyKey);
                return relationshipPropertyExistenceConstraintDefinition;
            }
            catch (AlreadyConstrainedException | CreateConstraintFailureException e) {
                try {
                    throw new ConstraintViolationException(e.getUserMessage(new StatementTokenNameLookup(statement.readOperations())), (Throwable)e);
                    catch (IllegalTokenNameException e2) {
                        throw new IllegalArgumentException(e2);
                    }
                    catch (InvalidTransactionTypeKernelException e3) {
                        throw new InvalidTransactionTypeException(e3.getMessage(), (Throwable)e3);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }

        @Override
        public void dropPropertyUniquenessConstraint(Label label, String propertyKey) {
            try (Statement statement = this.ctxSupplier.get();){
                try {
                    int labelId = statement.schemaWriteOperations().labelGetForName(label.name());
                    int propertyKeyId = statement.schemaWriteOperations().propertyKeyGetForName(propertyKey);
                    UniquenessConstraint constraint = new UniquenessConstraint(labelId, propertyKeyId);
                    statement.schemaWriteOperations().constraintDrop(constraint);
                }
                catch (DropConstraintFailureException e) {
                    throw new ConstraintViolationException(e.getUserMessage(new StatementTokenNameLookup(statement.readOperations())), (Throwable)e);
                }
                catch (InvalidTransactionTypeKernelException e) {
                    throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
                }
            }
        }

        @Override
        public void dropNodePropertyExistenceConstraint(Label label, String propertyKey) {
            try (Statement statement = this.ctxSupplier.get();){
                try {
                    int labelId = statement.schemaWriteOperations().labelGetForName(label.name());
                    int propertyKeyId = statement.schemaWriteOperations().propertyKeyGetForName(propertyKey);
                    NodePropertyExistenceConstraint constraint = new NodePropertyExistenceConstraint(labelId, propertyKeyId);
                    statement.schemaWriteOperations().constraintDrop(constraint);
                }
                catch (DropConstraintFailureException e) {
                    throw new ConstraintViolationException(e.getUserMessage(new StatementTokenNameLookup(statement.readOperations())), (Throwable)e);
                }
                catch (InvalidTransactionTypeKernelException e) {
                    throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
                }
            }
        }

        @Override
        public void dropRelationshipPropertyExistenceConstraint(RelationshipType type, String propertyKey) {
            try (Statement statement = this.ctxSupplier.get();){
                try {
                    int typeId = statement.schemaWriteOperations().relationshipTypeGetForName(type.name());
                    int propertyKeyId = statement.schemaWriteOperations().propertyKeyGetForName(propertyKey);
                    RelationshipPropertyExistenceConstraint constraint = new RelationshipPropertyExistenceConstraint(typeId, propertyKeyId);
                    statement.schemaWriteOperations().constraintDrop(constraint);
                }
                catch (DropConstraintFailureException e) {
                    throw new ConstraintViolationException(e.getUserMessage(new StatementTokenNameLookup(statement.readOperations())), (Throwable)e);
                }
                catch (InvalidTransactionTypeKernelException e) {
                    throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
                }
            }
        }

        @Override
        public String getUserMessage(KernelException e) {
            try (Statement statement = this.ctxSupplier.get();){
                String string = e.getUserMessage(new StatementTokenNameLookup(statement.readOperations()));
                return string;
            }
        }

        @Override
        public void assertInOpenTransaction() {
            this.ctxSupplier.get();
        }
    }
}

