/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.io.IOException;
import java.util.Collection;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.impl.api.index.updater.SwallowingIndexUpdater;
import org.neo4j.storageengine.api.schema.IndexSample;

public interface IndexPopulator {
    public void create() throws IOException;

    public void drop() throws IOException;

    public void add(Collection<NodePropertyUpdate> var1) throws IndexEntryConflictException, IOException;

    @Deprecated
    public void verifyDeferredConstraints(PropertyAccessor var1) throws IndexEntryConflictException, IOException;

    public IndexUpdater newPopulatingUpdater(PropertyAccessor var1) throws IOException;

    public void close(boolean var1) throws IOException;

    public void markAsFailed(String var1) throws IOException;

    public void includeSample(NodePropertyUpdate var1);

    public IndexSample sampleResult();

    public static class Adapter
    implements IndexPopulator {
        @Override
        public void create() throws IOException {
        }

        @Override
        public void drop() throws IOException {
        }

        @Override
        public void add(Collection<NodePropertyUpdate> updates) throws IndexEntryConflictException, IOException {
        }

        @Override
        public void verifyDeferredConstraints(PropertyAccessor accessor) throws IndexEntryConflictException, IOException {
        }

        @Override
        public IndexUpdater newPopulatingUpdater(PropertyAccessor accessor) {
            return SwallowingIndexUpdater.INSTANCE;
        }

        @Override
        public void close(boolean populationCompletedSuccessfully) throws IOException {
        }

        @Override
        public void markAsFailed(String failure) {
        }

        @Override
        public void includeSample(NodePropertyUpdate update) {
        }

        @Override
        public IndexSample sampleResult() {
            return new IndexSample();
        }
    }
}

