/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.lang.reflect.Array;
import java.util.stream.Stream;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.id.validation.IdValidator;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.unsafe.impl.batchimport.staging.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.IoProducerStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public abstract class ReadRecordsStep<RECORD extends AbstractBaseRecord>
extends IoProducerStep {
    protected final RecordStore<RECORD> store;
    protected final RECORD record;
    protected final RecordCursor<RECORD> cursor;
    protected final long highId;

    public ReadRecordsStep(StageControl control, Configuration config, RecordStore<RECORD> store) {
        super(control, config);
        this.store = store;
        this.record = store.newRecord();
        this.cursor = store.newRecordCursor(this.record);
        this.highId = store.getHighId();
    }

    @Override
    public void start(int orderingGuarantees) {
        this.cursor.acquire(0L, RecordLoad.CHECK);
        super.start(orderingGuarantees);
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.cursor.close();
    }

    protected RECORD[] removeRecordWithReservedId(RECORD[] records, boolean seenReservedId) {
        if (!seenReservedId) {
            return records;
        }
        return (AbstractBaseRecord[])Stream.of(records).filter(record -> !IdValidator.isReservedId(record.getId())).toArray(length -> this.newArray(length, records.getClass().getComponentType()));
    }

    private RECORD[] newArray(int length, Class<?> componentType) {
        return (AbstractBaseRecord[])Array.newInstance(componentType, length);
    }
}

