/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.Arrays;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.Batch;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.staging.BatchSender;
import org.neo4j.unsafe.impl.batchimport.staging.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.ProcessorStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public class CalculateDenseNodePrepareStep
extends ProcessorStep<Batch<InputRelationship, RelationshipRecord>> {
    public static final int RADIXES = 10;
    private final int batchSize;
    private final long[][] inProgressBatches;
    private final int[] cursors;
    private final Collector badCollector;

    public CalculateDenseNodePrepareStep(StageControl control, org.neo4j.unsafe.impl.batchimport.Configuration config, Collector badCollector) {
        super(control, "DIVIDE", (Configuration)config, 1, new StatsProvider[0]);
        this.badCollector = badCollector;
        this.batchSize = config.batchSize() * 2;
        this.inProgressBatches = new long[10][this.batchSize];
        this.cursors = new int[this.inProgressBatches.length];
    }

    @Override
    protected void process(Batch<InputRelationship, RelationshipRecord> batch, BatchSender sender) {
        long[] batchIds = batch.ids;
        InputRelationship[] input = (InputRelationship[])batch.input;
        int i = 0;
        int r = 0;
        while (i < batchIds.length) {
            boolean loop;
            long startNodeId = batchIds[i++];
            InputRelationship relationship = input[r];
            this.processNodeId(startNodeId, sender, relationship, relationship.startNode());
            long endNodeId = batchIds[i];
            boolean bl = loop = startNodeId == endNodeId;
            if (!loop) {
                this.processNodeId(endNodeId, sender, relationship, relationship.endNode());
            }
            ++i;
            ++r;
        }
    }

    private void processNodeId(long nodeId, BatchSender sender, InputRelationship relationship, Object inputId) {
        if (nodeId != -1L) {
            int startNodeRadix;
            int n = startNodeRadix = CalculateDenseNodePrepareStep.radixOf(nodeId);
            int n2 = this.cursors[n];
            this.cursors[n] = n2 + 1;
            this.inProgressBatches[startNodeRadix][n2] = nodeId;
            if (this.cursors[startNodeRadix] == this.batchSize) {
                sender.send(this.inProgressBatches[startNodeRadix]);
                this.inProgressBatches[startNodeRadix] = new long[this.batchSize];
                this.cursors[startNodeRadix] = 0;
            }
        } else {
            this.badCollector.collectBadRelationship(relationship, inputId);
        }
    }

    @Override
    protected void lastCallForEmittingOutstandingBatches(BatchSender sender) {
        for (int i = 0; i < this.cursors.length; ++i) {
            if (this.cursors[i] <= 0) continue;
            sender.send(this.cursors[i] == this.batchSize ? this.inProgressBatches[i] : Arrays.copyOf(this.inProgressBatches[i], this.cursors[i]));
        }
    }

    public static int radixOf(long nodeId) {
        return (int)(nodeId % 10L);
    }
}

