/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert;

import org.neo4j.kernel.impl.store.LabelTokenStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.RelationshipTypeTokenStore;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.kernel.impl.transaction.state.Loaders;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.kernel.impl.transaction.state.RecordAccessSet;
import org.neo4j.storageengine.api.schema.SchemaRule;
import org.neo4j.unsafe.batchinsert.DirectRecordAccess;

public class DirectRecordAccessSet
implements RecordAccessSet {
    private final DirectRecordAccess<Long, NodeRecord, Void> nodeRecords;
    private final DirectRecordAccess<Long, PropertyRecord, PrimitiveRecord> propertyRecords;
    private final DirectRecordAccess<Long, RelationshipRecord, Void> relationshipRecords;
    private final DirectRecordAccess<Long, RelationshipGroupRecord, Integer> relationshipGroupRecords;
    private final DirectRecordAccess<Integer, PropertyKeyTokenRecord, Void> propertyKeyTokenRecords;
    private final DirectRecordAccess<Integer, RelationshipTypeTokenRecord, Void> relationshipTypeTokenRecords;
    private final DirectRecordAccess<Integer, LabelTokenRecord, Void> labelTokenRecords;
    private final DirectRecordAccess[] all;

    public DirectRecordAccessSet(NeoStores neoStores) {
        Loaders loaders = new Loaders(neoStores);
        NodeStore nodeStore = neoStores.getNodeStore();
        PropertyStore propertyStore = neoStores.getPropertyStore();
        RelationshipStore relationshipStore = neoStores.getRelationshipStore();
        RecordStore<RelationshipGroupRecord> relationshipGroupStore = neoStores.getRelationshipGroupStore();
        PropertyKeyTokenStore propertyKeyTokenStore = neoStores.getPropertyKeyTokenStore();
        RelationshipTypeTokenStore relationshipTypeTokenStore = neoStores.getRelationshipTypeTokenStore();
        LabelTokenStore labelTokenStore = neoStores.getLabelTokenStore();
        this.nodeRecords = new DirectRecordAccess<Long, NodeRecord, Void>(nodeStore, loaders.nodeLoader());
        this.propertyRecords = new DirectRecordAccess<Long, PropertyRecord, PrimitiveRecord>(propertyStore, loaders.propertyLoader());
        this.relationshipRecords = new DirectRecordAccess<Long, RelationshipRecord, Void>(relationshipStore, loaders.relationshipLoader());
        this.relationshipGroupRecords = new DirectRecordAccess<Long, RelationshipGroupRecord, Integer>(relationshipGroupStore, loaders.relationshipGroupLoader());
        this.propertyKeyTokenRecords = new DirectRecordAccess<Integer, PropertyKeyTokenRecord, Void>(propertyKeyTokenStore, loaders.propertyKeyTokenLoader());
        this.relationshipTypeTokenRecords = new DirectRecordAccess<Integer, RelationshipTypeTokenRecord, Void>(relationshipTypeTokenStore, loaders.relationshipTypeTokenLoader());
        this.labelTokenRecords = new DirectRecordAccess<Integer, LabelTokenRecord, Void>(labelTokenStore, loaders.labelTokenLoader());
        this.all = new DirectRecordAccess[]{this.nodeRecords, this.propertyRecords, this.relationshipRecords, this.relationshipGroupRecords, this.propertyKeyTokenRecords, this.relationshipTypeTokenRecords, this.labelTokenRecords};
    }

    @Override
    public RecordAccess<Long, NodeRecord, Void> getNodeRecords() {
        return this.nodeRecords;
    }

    @Override
    public RecordAccess<Long, PropertyRecord, PrimitiveRecord> getPropertyRecords() {
        return this.propertyRecords;
    }

    @Override
    public RecordAccess<Long, RelationshipRecord, Void> getRelRecords() {
        return this.relationshipRecords;
    }

    @Override
    public RecordAccess<Long, RelationshipGroupRecord, Integer> getRelGroupRecords() {
        return this.relationshipGroupRecords;
    }

    @Override
    public RecordAccess<Long, SchemaRecord, SchemaRule> getSchemaRuleChanges() {
        throw new UnsupportedOperationException("Not needed. Implement if needed");
    }

    @Override
    public RecordAccess<Integer, PropertyKeyTokenRecord, Void> getPropertyKeyTokenChanges() {
        return this.propertyKeyTokenRecords;
    }

    @Override
    public RecordAccess<Integer, LabelTokenRecord, Void> getLabelTokenChanges() {
        return this.labelTokenRecords;
    }

    @Override
    public RecordAccess<Integer, RelationshipTypeTokenRecord, Void> getRelationshipTypeTokenChanges() {
        return this.relationshipTypeTokenRecords;
    }

    @Override
    public void close() {
        this.commit();
        for (DirectRecordAccess access : this.all) {
            access.close();
        }
    }

    public void commit() {
        for (DirectRecordAccess access : this.all) {
            access.commit();
        }
    }

    @Override
    public boolean hasChanges() {
        for (DirectRecordAccess access : this.all) {
            if (access.changeSize() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public int changeSize() {
        int total = 0;
        for (DirectRecordAccess access : this.all) {
            total += access.changeSize();
        }
        return total;
    }
}

