/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.api.cursor.EntityItemHelper;
import org.neo4j.kernel.impl.api.store.StorePropertyCursor;
import org.neo4j.kernel.impl.api.store.StoreSinglePropertyCursor;
import org.neo4j.kernel.impl.api.store.StoreStatement;
import org.neo4j.kernel.impl.locking.Lock;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.util.InstanceCache;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.storageengine.api.RelationshipItem;

public abstract class StoreAbstractRelationshipCursor
extends EntityItemHelper
implements Cursor<RelationshipItem>,
RelationshipItem {
    protected final RelationshipRecord relationshipRecord;
    protected final RelationshipStore relationshipStore;
    protected final RecordStore<RelationshipGroupRecord> relationshipGroupStore;
    private final LockService lockService;
    protected StoreStatement storeStatement;
    private InstanceCache<StoreSinglePropertyCursor> singlePropertyCursor;
    private InstanceCache<StorePropertyCursor> allPropertyCursor;

    public StoreAbstractRelationshipCursor(RelationshipRecord relationshipRecord, final NeoStores neoStores, StoreStatement storeStatement, LockService lockService) {
        this.lockService = lockService;
        this.relationshipStore = neoStores.getRelationshipStore();
        this.relationshipGroupStore = neoStores.getRelationshipGroupStore();
        this.relationshipRecord = relationshipRecord;
        this.storeStatement = storeStatement;
        this.singlePropertyCursor = new InstanceCache<StoreSinglePropertyCursor>(){

            @Override
            protected StoreSinglePropertyCursor create() {
                return new StoreSinglePropertyCursor(neoStores.getPropertyStore(), this);
            }
        };
        this.allPropertyCursor = new InstanceCache<StorePropertyCursor>(){

            @Override
            protected StorePropertyCursor create() {
                return new StorePropertyCursor(neoStores.getPropertyStore(), this);
            }
        };
    }

    public RelationshipItem get() {
        return this;
    }

    @Override
    public long id() {
        return this.relationshipRecord.getId();
    }

    @Override
    public int type() {
        return this.relationshipRecord.getType();
    }

    @Override
    public long startNode() {
        return this.relationshipRecord.getFirstNode();
    }

    @Override
    public long endNode() {
        return this.relationshipRecord.getSecondNode();
    }

    @Override
    public long otherNode(long nodeId) {
        return this.relationshipRecord.getFirstNode() == nodeId ? this.relationshipRecord.getSecondNode() : this.relationshipRecord.getFirstNode();
    }

    private Lock shortLivedReadLock() {
        Lock lock = this.lockService.acquireRelationshipLock(this.relationshipRecord.getId(), LockService.LockType.READ_LOCK);
        if (this.lockService != LockService.NO_LOCK_SERVICE) {
            boolean success = true;
            try {
                if (!this.relationshipStore.getRecord(this.relationshipRecord.getId(), this.relationshipRecord, RecordLoad.CHECK).inUse()) {
                    this.relationshipRecord.setNextProp(Record.NO_NEXT_PROPERTY.intValue());
                }
                success = true;
            }
            finally {
                if (!success) {
                    lock.release();
                }
            }
        }
        return lock;
    }

    @Override
    public Cursor<PropertyItem> properties() {
        Lock lock = this.shortLivedReadLock();
        return this.allPropertyCursor.get().init(this.relationshipRecord.getNextProp(), lock);
    }

    @Override
    public Cursor<PropertyItem> property(int propertyKeyId) {
        Lock lock = this.shortLivedReadLock();
        return this.singlePropertyCursor.get().init(this.relationshipRecord.getNextProp(), propertyKeyId, lock);
    }
}

