/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.io.IOException;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.PositionAwareChannel;
import org.neo4j.storageengine.api.CommandReader;
import org.neo4j.storageengine.api.ReadableChannel;

public abstract class BaseCommandReader
implements CommandReader {
    @Override
    public final Command read(ReadableChannel channel) throws IOException {
        byte commandType = 0;
        while (commandType == 0) {
            commandType = channel.get();
        }
        if (commandType == 0) {
            return null;
        }
        return this.read(commandType, channel);
    }

    protected abstract Command read(byte var1, ReadableChannel var2) throws IOException;

    protected IOException unknownCommandType(byte commandType, ReadableChannel channel) throws IOException {
        String message = "Unknown command type[" + commandType + "]";
        if (channel instanceof PositionAwareChannel) {
            PositionAwareChannel logChannel = (PositionAwareChannel)((Object)channel);
            LogPositionMarker position = new LogPositionMarker();
            logChannel.getCurrentPosition(position);
            message = message + " near " + position.newPosition();
        }
        return new IOException(message);
    }
}

