/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format.standard;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.impl.store.format.BaseOneByteHeaderRecordFormat;
import org.neo4j.kernel.impl.store.format.BaseRecordFormat;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;

public class DynamicRecordFormat
extends BaseOneByteHeaderRecordFormat<DynamicRecord> {
    public static final int RECORD_HEADER_SIZE = 8;

    public DynamicRecordFormat() {
        super(INT_STORE_HEADER_READER, 8, 16, 36);
    }

    @Override
    public DynamicRecord newRecord() {
        return new DynamicRecord(-1L);
    }

    @Override
    public void read(DynamicRecord record, PageCursor cursor, RecordLoad mode, int recordSize, PagedFile storeFile) {
        boolean inUse;
        long firstInteger = (long)cursor.getInt() & 0xFFFFFFFFL;
        boolean isStartRecord = (firstInteger & Integer.MIN_VALUE) == 0L;
        boolean bl = inUse = (firstInteger & 0x10000000L) != 0L;
        if (mode.shouldLoad(inUse)) {
            int dataSize = recordSize - this.getRecordHeaderSize();
            int nrOfBytes = (int)(firstInteger & 0xFFFFFFL);
            long nextBlock = (long)cursor.getInt() & 0xFFFFFFFFL;
            long nextModifier = (firstInteger & 0xF000000L) << 8;
            long longNextBlock = BaseRecordFormat.longFromIntAndMod(nextBlock, nextModifier);
            record.initialize(inUse, isStartRecord, longNextBlock, -1, nrOfBytes);
            if (longNextBlock != (long)Record.NO_NEXT_BLOCK.intValue() && nrOfBytes < dataSize || nrOfBytes > dataSize) {
                mode.report(String.format("Next block set[%d] current block illegal size[%d/%d]", record.getNextBlock(), record.getLength(), dataSize));
            }
            DynamicRecordFormat.readData(record, cursor);
        }
    }

    public static void readData(DynamicRecord record, PageCursor cursor) {
        if (record.getLength() == 0) {
            record.setData(DynamicRecord.NO_DATA);
            return;
        }
        int len = record.getLength();
        byte[] data = record.getData();
        if (data == null || data.length != len) {
            data = new byte[len];
        }
        cursor.getBytes(data);
        record.setData(data);
    }

    @Override
    public void write(DynamicRecord record, PageCursor cursor, int recordSize, PagedFile storeFile) {
        if (record.inUse()) {
            long nextBlock = record.getNextBlock();
            int highByteInFirstInteger = nextBlock == (long)Record.NO_NEXT_BLOCK.intValue() ? 0 : (int)((nextBlock & 0xF00000000L) >> 8);
            highByteInFirstInteger |= Record.IN_USE.byteValue() << 28;
            highByteInFirstInteger |= (record.isStartRecord() ? 0 : 1) << 31;
            int firstInteger = record.getLength();
            assert (firstInteger < 0xFFFFFF);
            cursor.putInt(firstInteger |= highByteInFirstInteger);
            cursor.putInt((int)nextBlock);
            cursor.putBytes(record.getData());
        } else {
            cursor.putByte(Record.NOT_IN_USE.byteValue());
        }
    }

    @Override
    public long getNextRecordReference(DynamicRecord record) {
        return record.getNextBlock();
    }
}

