/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.kernel.impl.core.NonUniqueTokenException;
import org.neo4j.kernel.impl.util.CopyOnWriteHashMap;
import org.neo4j.storageengine.api.Token;

public class InMemoryTokenCache<TOKEN extends Token> {
    private final Map<String, Integer> nameToId = new CopyOnWriteHashMap<String, Integer>();
    private final Map<Integer, TOKEN> idToToken = new CopyOnWriteHashMap<Integer, TOKEN>();
    private final String tokenType;

    public InMemoryTokenCache(String tokenType) {
        this.tokenType = tokenType;
    }

    public void clear() {
        this.nameToId.clear();
        this.idToToken.clear();
    }

    private void putAndEnsureUnique(Map<String, Integer> nameToId, Token token, String tokenType) {
        Integer previous = nameToId.putIfAbsent(token.name(), token.id());
        if (previous != null && previous.intValue() != token.id()) {
            this.idToToken.remove(token.id(), token);
            throw new NonUniqueTokenException(tokenType, token.name(), token.id(), previous);
        }
    }

    public void putAll(List<TOKEN> tokens) throws NonUniqueTokenException {
        HashMap<String, Integer> newNameToId = new HashMap<String, Integer>();
        HashMap<Integer, Token> newIdToToken = new HashMap<Integer, Token>();
        for (Token token : tokens) {
            newIdToToken.put(token.id(), token);
            this.putAndEnsureUnique(newNameToId, token, this.tokenType);
        }
        this.idToToken.putAll(newIdToToken);
        this.nameToId.putAll(newNameToId);
    }

    public void put(TOKEN token) throws NonUniqueTokenException {
        this.idToToken.put(((Token)token).id(), token);
        this.putAndEnsureUnique(this.nameToId, (Token)token, this.tokenType);
    }

    public Integer getId(String name) {
        return this.nameToId.get(name);
    }

    public TOKEN getToken(int id) {
        return (TOKEN)((Token)this.idToToken.get(id));
    }

    public Iterable<TOKEN> allTokens() {
        return this.idToToken.values();
    }

    public int size() {
        return this.nameToId.size();
    }
}

