/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import org.neo4j.kernel.impl.api.store.StoreAbstractRelationshipCursor;
import org.neo4j.kernel.impl.api.store.StoreStatement;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.util.InstanceCache;

public class StoreSingleRelationshipCursor
extends StoreAbstractRelationshipCursor {
    private long relationshipId = -1L;
    private final InstanceCache<StoreSingleRelationshipCursor> instanceCache;

    public StoreSingleRelationshipCursor(RelationshipRecord relationshipRecord, NeoStores neoStores, StoreStatement storeStatement, InstanceCache<StoreSingleRelationshipCursor> instanceCache, LockService lockService) {
        super(relationshipRecord, neoStores, storeStatement, lockService);
        this.instanceCache = instanceCache;
    }

    public StoreSingleRelationshipCursor init(long relId) {
        this.relationshipId = relId;
        return this;
    }

    public boolean next() {
        if (this.relationshipId != -1L) {
            try {
                this.relationshipRecord.setId(this.relationshipId);
                boolean bl = this.relationshipStore.getRecord(this.relationshipId, this.relationshipRecord, RecordLoad.CHECK).inUse();
                return bl;
            }
            finally {
                this.relationshipId = -1L;
            }
        }
        return false;
    }

    public void close() {
        this.instanceCache.accept(this);
    }
}

