/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.lowlimit.LowLimitV2_0;
import org.neo4j.kernel.impl.store.format.lowlimit.LowLimitV2_1;
import org.neo4j.kernel.impl.store.format.lowlimit.LowLimitV2_2;
import org.neo4j.kernel.impl.store.format.lowlimit.LowLimitV2_3;
import org.neo4j.kernel.impl.store.format.lowlimit.LowLimitV3_0;
import org.neo4j.logging.Log;

public class RecordFormatSelector {
    private static final RecordFormats DEFAULT_AUTOSELECT_FORMAT = LowLimitV3_0.RECORD_FORMATS;
    private static final Iterable<RecordFormats> KNOWN_FORMATS = Arrays.asList(LowLimitV2_0.RECORD_FORMATS, LowLimitV2_1.RECORD_FORMATS, LowLimitV2_2.RECORD_FORMATS, LowLimitV2_3.RECORD_FORMATS, LowLimitV3_0.RECORD_FORMATS);

    public static RecordFormats select(Config config, LogService logService) {
        String recordFormat = RecordFormatSelector.configuredRecordFormat(config);
        RecordFormats formats = RecordFormatSelector.loadRecordFormat(recordFormat);
        if (formats == null) {
            RecordFormatSelector.handleMissingFormat(recordFormat, logService);
        }
        RecordFormatSelector.logSelectedFormat(logService, formats);
        return formats;
    }

    public static RecordFormats select(Config config, RecordFormats defaultFormat, LogService logService) {
        RecordFormats selectedFormat = defaultFormat;
        String recordFormat = RecordFormatSelector.configuredRecordFormat(config);
        if (StringUtils.isNotEmpty((CharSequence)recordFormat)) {
            selectedFormat = RecordFormatSelector.selectSpecificFormat(recordFormat, logService);
        }
        RecordFormatSelector.logSelectedFormat(logService, selectedFormat);
        return selectedFormat;
    }

    public static RecordFormats selectForVersion(String storeVersion) {
        Iterable currentFormats = Iterables.map(RecordFormats.Factory::newInstance, Service.load(RecordFormats.Factory.class));
        for (RecordFormats format : Iterables.concat((Iterable[])new Iterable[]{KNOWN_FORMATS, currentFormats})) {
            if (!format.storeVersion().equals(storeVersion)) continue;
            return format;
        }
        throw new IllegalArgumentException("Unknown store version '" + storeVersion + "'");
    }

    public static RecordFormats autoSelectFormat() {
        return RecordFormatSelector.autoSelectFormat(Config.empty(), NullLogService.getInstance());
    }

    public static RecordFormats autoSelectFormat(Config config, LogService logService) {
        String recordFormat = RecordFormatSelector.configuredRecordFormat(config);
        RecordFormats recordFormats = StringUtils.isNotEmpty((CharSequence)recordFormat) ? RecordFormatSelector.selectSpecificFormat(recordFormat, logService) : RecordFormatSelector.getFirstAvailableOrDefault(DEFAULT_AUTOSELECT_FORMAT);
        RecordFormatSelector.logSelectedFormat(logService, recordFormats);
        return recordFormats;
    }

    private static RecordFormats selectSpecificFormat(String recordFormat, LogService logService) {
        RecordFormats formats = RecordFormatSelector.loadRecordFormat(recordFormat);
        if (formats == null) {
            return RecordFormatSelector.handleMissingFormat(recordFormat, logService);
        }
        return formats;
    }

    private static RecordFormats getFirstAvailableOrDefault(RecordFormats defaultAutoSelectFormat) {
        Iterable<RecordFormats.Factory> formatFactories = Service.load(RecordFormats.Factory.class);
        Iterator<RecordFormats.Factory> factoryIterator = formatFactories.iterator();
        return factoryIterator.hasNext() ? factoryIterator.next().newInstance() : defaultAutoSelectFormat;
    }

    private static RecordFormats loadRecordFormat(String recordFormat) {
        if (StringUtils.isNotEmpty((CharSequence)recordFormat)) {
            if ("community".equals(recordFormat)) {
                return LowLimitV3_0.RECORD_FORMATS;
            }
            RecordFormats.Factory formatFactory = Service.loadSilently(RecordFormats.Factory.class, recordFormat);
            if (formatFactory != null) {
                return formatFactory.newInstance();
            }
        }
        return null;
    }

    private static void logSelectedFormat(LogService logService, RecordFormats formats) {
        String selectionMessage = String.format("Select %s as record format implementation.", formats.getClass().getName());
        RecordFormatSelector.getLog(logService).warn(selectionMessage);
    }

    private static RecordFormats handleMissingFormat(String recordFormat, LogService logService) {
        RecordFormatSelector.getLog(logService).warn("Record format with key '" + recordFormat + "' not found.");
        throw new IllegalArgumentException("No record format found with the name '" + recordFormat + "'.");
    }

    private static Log getLog(LogService logService) {
        return logService.getInternalLog(RecordFormatSelector.class);
    }

    private static String configuredRecordFormat(Config config) {
        return config.get(GraphDatabaseFacadeFactory.Configuration.record_format);
    }
}

