/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.IntStoreHeader;
import org.neo4j.kernel.impl.store.IntStoreHeaderFormat;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.format.RecordFormat;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.logging.LogProvider;

public abstract class AbstractDynamicStore
extends CommonAbstractStore<DynamicRecord, IntStoreHeader>
implements DynamicRecordAllocator {
    public static final byte[] NO_DATA = new byte[0];

    public AbstractDynamicStore(File fileName, Config conf, IdType idType, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, LogProvider logProvider, String typeDescriptor, int dataSizeFromConfiguration, RecordFormat<DynamicRecord> recordFormat, String storeVersion) {
        super(fileName, conf, idType, idGeneratorFactory, pageCache, logProvider, typeDescriptor, recordFormat, new DynamicStoreHeaderFormat(dataSizeFromConfiguration, recordFormat), storeVersion);
    }

    public static void allocateRecordsFromBytes(Collection<DynamicRecord> recordList, byte[] src, Iterator<DynamicRecord> recordsToUseFirst, DynamicRecordAllocator dynamicRecordAllocator) {
        assert (src != null) : "Null src argument";
        DynamicRecord nextRecord = dynamicRecordAllocator.nextUsedRecordOrNew(recordsToUseFirst);
        int srcOffset = 0;
        int dataSize = dynamicRecordAllocator.getRecordDataSize();
        do {
            byte[] data;
            DynamicRecord record = nextRecord;
            record.setStartRecord(srcOffset == 0);
            if (src.length - srcOffset > dataSize) {
                data = new byte[dataSize];
                System.arraycopy(src, srcOffset, data, 0, dataSize);
                record.setData(data);
                nextRecord = dynamicRecordAllocator.nextUsedRecordOrNew(recordsToUseFirst);
                record.setNextBlock(nextRecord.getId());
                srcOffset += dataSize;
            } else {
                data = new byte[src.length - srcOffset];
                System.arraycopy(src, srcOffset, data, 0, data.length);
                record.setData(data);
                nextRecord = null;
                record.setNextBlock(Record.NO_NEXT_BLOCK.intValue());
            }
            recordList.add(record);
            assert (record.getData() != null);
        } while (nextRecord != null);
    }

    public static ByteBuffer concatData(Collection<DynamicRecord> records, byte[] target) {
        int totalLength = 0;
        for (DynamicRecord record : records) {
            totalLength += record.getLength();
        }
        if (target.length < totalLength) {
            target = new byte[totalLength];
        }
        ByteBuffer buffer = ByteBuffer.wrap(target, 0, totalLength);
        for (DynamicRecord record : records) {
            buffer.put(record.getData());
        }
        buffer.position(0);
        return buffer;
    }

    public static Pair<byte[], byte[]> readFullByteArrayFromHeavyRecords(Iterable<DynamicRecord> records, PropertyType propertyType) {
        int offset;
        byte[] header = null;
        ArrayList<byte[]> byteList = new ArrayList<byte[]>();
        int totalSize = 0;
        int i = 0;
        for (DynamicRecord record : records) {
            offset = 0;
            if (i++ == 0) {
                header = propertyType.readDynamicRecordHeader(record.getData());
                offset = header.length;
            }
            byteList.add(record.getData());
            totalSize += record.getData().length - offset;
        }
        byte[] bArray = new byte[totalSize];
        assert (header != null) : "header should be non-null since records should not be empty";
        int sourceOffset = header.length;
        offset = 0;
        for (byte[] currentArray : byteList) {
            System.arraycopy(currentArray, sourceOffset, bArray, offset, currentArray.length - sourceOffset);
            offset += currentArray.length - sourceOffset;
            sourceOffset = 0;
        }
        return Pair.of((Object)header, (Object)bArray);
    }

    @Override
    public DynamicRecord nextUsedRecordOrNew(Iterator<DynamicRecord> recordsToUseFirst) {
        DynamicRecord record;
        if (recordsToUseFirst.hasNext()) {
            record = recordsToUseFirst.next();
            if (!record.inUse()) {
                record.setCreated();
            }
        } else {
            record = new DynamicRecord(this.nextId());
            record.setCreated();
        }
        record.setInUse(true);
        return record;
    }

    public void allocateRecordsFromBytes(Collection<DynamicRecord> target, byte[] src) {
        AbstractDynamicStore.allocateRecordsFromBytes(target, src, (Iterator<DynamicRecord>)Iterators.emptyIterator(), this);
    }

    @Override
    public String toString() {
        return super.toString() + "[fileName:" + this.storageFileName.getName() + ", blockSize:" + this.getRecordDataSize() + "]";
    }

    public Pair<byte[], byte[]> readFullByteArray(Iterable<DynamicRecord> records, PropertyType propertyType) {
        for (DynamicRecord record : records) {
            this.ensureHeavy(record);
        }
        return AbstractDynamicStore.readFullByteArrayFromHeavyRecords(records, propertyType);
    }

    private static class DynamicStoreHeaderFormat
    extends IntStoreHeaderFormat {
        DynamicStoreHeaderFormat(int dataSizeFromConfiguration, RecordFormat<DynamicRecord> recordFormat) {
            super(dataSizeFromConfiguration + recordFormat.getRecordHeaderSize());
        }

        @Override
        public void writeHeader(PageCursor cursor) {
            if (this.defaultValue < 1 || this.defaultValue > 65535) {
                throw new IllegalArgumentException("Illegal block size[" + this.defaultValue + "], limit is 65535");
            }
            super.writeHeader(cursor);
        }
    }
}

