/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.ArrayList;
import java.util.Collection;
import org.neo4j.kernel.api.index.NodePropertyUpdate;

public class NodePropertyUpdates {
    private Collection<NodePropertyUpdate> propertyUpdates = new ArrayList<NodePropertyUpdate>();
    private long nodeId;

    public void reset() {
        this.propertyUpdates.clear();
        this.nodeId = -1L;
    }

    public void initForNodeId(long nodeId) {
        if (this.containsUpdates()) {
            throw new AssertionError((Object)"Please clear updates fom previous node.");
        }
        this.nodeId = nodeId;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public void add(NodePropertyUpdate update) {
        this.propertyUpdates.add(update);
    }

    public void add(int propertyKeyId, Object value, long[] labels) {
        if (this.nodeId == -1L) {
            throw new AssertionError((Object)"Please init property updates container for specific node.");
        }
        this.propertyUpdates.add(NodePropertyUpdate.add(this.nodeId, propertyKeyId, value, labels));
    }

    public boolean containsUpdates() {
        return !this.propertyUpdates.isEmpty();
    }

    public Collection<NodePropertyUpdate> getPropertyUpdates() {
        return this.propertyUpdates;
    }

    public void addAll(Collection<NodePropertyUpdate> propertyUpdates) {
        this.propertyUpdates.addAll(propertyUpdates);
    }
}

