/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.LabelScanWriter;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.UpdateRecordsStep;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public class UpdateNodeRecordsStep
extends UpdateRecordsStep<NodeRecord> {
    private final PrimitiveLongIterator ids;
    private long current;
    private boolean end;
    private final LabelScanWriter labelScanWriter;

    public UpdateNodeRecordsStep(StageControl control, Configuration config, RecordStore<NodeRecord> store, Collector collector, LabelScanStore labelScanStore) {
        super(control, config, store);
        this.ids = collector.leftOverDuplicateNodesIds();
        this.goToNextId();
        this.labelScanWriter = this.end ? LabelScanWriter.EMPTY : labelScanStore.newWriter();
    }

    private void goToNextId() {
        boolean bl = this.end = !this.ids.hasNext();
        if (!this.end) {
            this.current = this.ids.next();
        }
    }

    @Override
    protected boolean accept(NodeRecord node) {
        if (!this.end && this.current == node.getId()) {
            this.goToNextId();
            return false;
        }
        return true;
    }

    @Override
    protected void update(NodeRecord node) throws Throwable {
        super.update(node);
        if (!node.inUse()) {
            this.labelScanWriter.write(NodeLabelUpdate.labelChanges(this.current, PrimitiveLongCollections.EMPTY_LONG_ARRAY, PrimitiveLongCollections.EMPTY_LONG_ARRAY));
        }
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.labelScanWriter.close();
    }
}

