/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.kernel.impl.util.statistics.IntCounter;

public class DirectRecordAccess<KEY extends Comparable<KEY>, RECORD extends AbstractBaseRecord, ADDITIONAL>
implements RecordAccess<KEY, RECORD, ADDITIONAL> {
    private final RecordStore<RECORD> store;
    private final RecordAccess.Loader<KEY, RECORD, ADDITIONAL> loader;
    private final Map<KEY, DirectRecordProxy> batch = new HashMap<KEY, DirectRecordProxy>();
    private final IntCounter changeCounter = new IntCounter();

    public DirectRecordAccess(RecordStore<RECORD> store, RecordAccess.Loader<KEY, RECORD, ADDITIONAL> loader) {
        this.store = store;
        this.loader = loader;
    }

    @Override
    public RecordAccess.RecordProxy<KEY, RECORD, ADDITIONAL> getOrLoad(KEY key, ADDITIONAL additionalData) {
        DirectRecordProxy loaded = this.batch.get(key);
        if (loaded != null) {
            return loaded;
        }
        return this.putInBatch(key, this.proxy(key, (AbstractBaseRecord)this.loader.load(key, additionalData), additionalData, false));
    }

    private RecordAccess.RecordProxy<KEY, RECORD, ADDITIONAL> putInBatch(KEY key, DirectRecordProxy proxy) {
        DirectRecordProxy previous = this.batch.put(key, proxy);
        assert (previous == null);
        return proxy;
    }

    @Override
    public RecordAccess.RecordProxy<KEY, RECORD, ADDITIONAL> create(KEY key, ADDITIONAL additionalData) {
        return this.putInBatch(key, this.proxy(key, (AbstractBaseRecord)this.loader.newUnused(key, additionalData), additionalData, true));
    }

    @Override
    public RecordAccess.RecordProxy<KEY, RECORD, ADDITIONAL> getIfLoaded(KEY key) {
        return this.batch.get(key);
    }

    @Override
    public void setTo(KEY key, RECORD newRecord, ADDITIONAL additionalData) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public int changeSize() {
        return this.changeCounter.value();
    }

    @Override
    public Iterable<RecordAccess.RecordProxy<KEY, RECORD, ADDITIONAL>> changes() {
        return new IterableWrapper<RecordAccess.RecordProxy<KEY, RECORD, ADDITIONAL>, DirectRecordProxy>(this.batch.values()){

            protected RecordAccess.RecordProxy<KEY, RECORD, ADDITIONAL> underlyingObjectToObject(DirectRecordProxy object) {
                return object;
            }
        };
    }

    private DirectRecordProxy proxy(KEY key, RECORD record, ADDITIONAL additionalData, boolean created) {
        return new DirectRecordProxy(this, key, record, additionalData, created);
    }

    @Override
    public void close() {
        this.commit();
    }

    public void commit() {
        if (this.changeCounter.value() == 0) {
            return;
        }
        ArrayList<DirectRecordProxy> directRecordProxies = new ArrayList<DirectRecordProxy>(this.batch.values());
        Collections.sort(directRecordProxies, new Comparator<DirectRecordProxy>(){

            @Override
            public int compare(DirectRecordProxy o1, DirectRecordProxy o2) {
                return -o1.getKey().compareTo(o2.getKey());
            }
        });
        for (DirectRecordProxy proxy : directRecordProxies) {
            proxy.store();
        }
        this.changeCounter.clear();
        this.batch.clear();
    }

    private class DirectRecordProxy
    implements RecordAccess.RecordProxy<KEY, RECORD, ADDITIONAL> {
        private final KEY key;
        private final RECORD record;
        private final ADDITIONAL additionalData;
        private boolean changed = false;
        final /* synthetic */ DirectRecordAccess this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public DirectRecordProxy(KEY key, RECORD record, ADDITIONAL additionalData, boolean created) {
            this.this$0 = (DirectRecordAccess)n;
            this.key = key;
            this.record = record;
            this.additionalData = additionalData;
            if (created) {
                this.prepareChange();
            }
        }

        @Override
        public KEY getKey() {
            return this.key;
        }

        @Override
        public RECORD forChangingLinkage() {
            this.prepareChange();
            return this.record;
        }

        private void prepareChange() {
            if (!this.changed) {
                this.changed = true;
                this.this$0.changeCounter.increment();
            }
        }

        @Override
        public RECORD forChangingData() {
            this.this$0.loader.ensureHeavy(this.record);
            this.prepareChange();
            return this.record;
        }

        @Override
        public RECORD forReadingLinkage() {
            return this.record;
        }

        @Override
        public RECORD forReadingData() {
            this.this$0.loader.ensureHeavy(this.record);
            return this.record;
        }

        @Override
        public ADDITIONAL getAdditionalData() {
            return this.additionalData;
        }

        @Override
        public RECORD getBefore() {
            return (AbstractBaseRecord)this.this$0.loader.load(this.key, this.additionalData);
        }

        public String toString() {
            return this.record.toString();
        }

        public void store() {
            if (this.changed) {
                this.this$0.store.updateRecord(this.record);
            }
        }

        @Override
        public boolean isChanged() {
            return this.changed;
        }
    }
}

