/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.recovery.LatestCheckPointFinder;
import org.neo4j.kernel.recovery.PositionToRecoverFrom;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.storageengine.api.StorageEngine;

public class DefaultRecoverySPI
implements Recovery.SPI {
    private final Visitor<LogVersionedStoreChannel, Exception> logFileRecoverer;
    private final PhysicalLogFiles logFiles;
    private final FileSystemAbstraction fileSystemAbstraction;
    private final LogVersionRepository logVersionRepository;
    private final PositionToRecoverFrom positionToRecoverFrom;
    private final StorageEngine storageEngine;

    public DefaultRecoverySPI(StorageEngine storageEngine, Visitor<LogVersionedStoreChannel, Exception> logFileRecoverer, PhysicalLogFiles logFiles, FileSystemAbstraction fileSystemAbstraction, LogVersionRepository logVersionRepository, LatestCheckPointFinder checkPointFinder) {
        this.storageEngine = storageEngine;
        this.logFileRecoverer = logFileRecoverer;
        this.logFiles = logFiles;
        this.fileSystemAbstraction = fileSystemAbstraction;
        this.logVersionRepository = logVersionRepository;
        this.positionToRecoverFrom = new PositionToRecoverFrom(checkPointFinder);
    }

    @Override
    public void forceEverything() {
        this.storageEngine.flushAndForce();
    }

    @Override
    public Visitor<LogVersionedStoreChannel, Exception> getRecoverer() {
        return this.logFileRecoverer;
    }

    @Override
    public Iterator<LogVersionedStoreChannel> getLogFiles(final long fromVersion) throws IOException {
        return new Iterator<LogVersionedStoreChannel>(){
            private long currentVersion;
            private LogVersionedStoreChannel current;
            {
                this.currentVersion = fromVersion;
                this.current = PhysicalLogFile.tryOpenForVersion(DefaultRecoverySPI.this.logFiles, DefaultRecoverySPI.this.fileSystemAbstraction, this.currentVersion);
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public LogVersionedStoreChannel next() {
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                LogVersionedStoreChannel tmp = this.current;
                this.current = PhysicalLogFile.tryOpenForVersion(DefaultRecoverySPI.this.logFiles, DefaultRecoverySPI.this.fileSystemAbstraction, ++this.currentVersion);
                return tmp;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public LogPosition getPositionToRecoverFrom() throws IOException {
        return this.positionToRecoverFrom.apply(this.logVersionRepository.getCurrentLogVersion());
    }

    @Override
    public void recoveryRequired() {
        this.storageEngine.prepareForRecoveryRequired();
    }
}

