/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.participant;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.function.BiConsumer;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.store.StorePropertyCursor;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.store.CountsComputer;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.format.Capability;
import org.neo4j.kernel.impl.store.format.CapabilityType;
import org.neo4j.kernel.impl.store.format.InternalRecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.id.IdGeneratorImpl;
import org.neo4j.kernel.impl.store.id.ReadOnlyIdGeneratorFactory;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.storemigration.DirectRecordStoreMigrator;
import org.neo4j.kernel.impl.storemigration.ExistingTargetStrategy;
import org.neo4j.kernel.impl.storemigration.FileOperation;
import org.neo4j.kernel.impl.storemigration.StoreFile;
import org.neo4j.kernel.impl.storemigration.StoreFileType;
import org.neo4j.kernel.impl.storemigration.StoreMigratorCheckPointer;
import org.neo4j.kernel.impl.storemigration.legacylogs.LegacyLogs;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.PropertyDeduplicator;
import org.neo4j.kernel.impl.storemigration.monitoring.MigrationProgressMonitor;
import org.neo4j.kernel.impl.storemigration.participant.AbstractStoreMigrationParticipant;
import org.neo4j.kernel.impl.storemigration.participant.StoreScanAsInputIterable;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.unsafe.impl.batchimport.AdditionalInitialIds;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.ParallelBatchImporter;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdGenerators;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMappers;
import org.neo4j.unsafe.impl.batchimport.input.Collectors;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.input.Inputs;
import org.neo4j.unsafe.impl.batchimport.staging.CoarseBoundedProgressExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionSupervisors;
import org.neo4j.unsafe.impl.batchimport.store.BatchingNeoStores;

public class StoreMigrator
extends AbstractStoreMigrationParticipant {
    private final Config config;
    private final LogService logService;
    private final LegacyLogs legacyLogs;
    private final FileSystemAbstraction fileSystem;
    private final PageCache pageCache;
    private final SchemaIndexProvider schemaIndexProvider;

    public StoreMigrator(FileSystemAbstraction fileSystem, PageCache pageCache, Config config, LogService logService, SchemaIndexProvider schemaIndexProvider) {
        super("Store files");
        this.fileSystem = fileSystem;
        this.pageCache = pageCache;
        this.config = config;
        this.logService = logService;
        this.schemaIndexProvider = schemaIndexProvider;
        this.legacyLogs = new LegacyLogs(fileSystem);
    }

    @Override
    public void migrate(File storeDir, File migrationDir, MigrationProgressMonitor.Section progressMonitor, String versionToMigrateFrom, String versionToMigrateTo) throws IOException {
        File neoStore = new File(storeDir, "neostore");
        long lastTxId = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_TRANSACTION_ID);
        long lastTxChecksum = this.extractTransactionChecksum(neoStore, storeDir, lastTxId);
        LogPosition lastTxLogPosition = this.extractTransactionLogPosition(neoStore, storeDir, lastTxId);
        this.writeLastTxChecksum(migrationDir, lastTxChecksum);
        this.writeLastTxLogPosition(migrationDir, lastTxLogPosition);
        RecordFormats oldFormat = InternalRecordFormatSelector.fromVersion(versionToMigrateFrom);
        RecordFormats newFormat = InternalRecordFormatSelector.fromVersion(versionToMigrateTo);
        if (!oldFormat.equals(newFormat)) {
            if (newFormat.hasSameCapabilities(oldFormat, CapabilityType.FORMAT)) {
                this.migrateWithDirectMigration(storeDir, migrationDir, oldFormat, newFormat);
            } else {
                this.migrateWithBatchImporter(storeDir, migrationDir, lastTxId, lastTxChecksum, lastTxLogPosition.getLogVersion(), lastTxLogPosition.getByteOffset(), progressMonitor, oldFormat, newFormat);
            }
        }
        if (versionToMigrateFrom.equals("v0.A.3")) {
            this.removeDuplicateEntityProperties(storeDir, migrationDir, this.pageCache, this.schemaIndexProvider, oldFormat);
        }
    }

    private void migrateWithDirectMigration(File storeDir, File migrationDir, RecordFormats oldFormat, RecordFormats newFormat) {
        DirectRecordStoreMigrator migrator = new DirectRecordStoreMigrator(this.pageCache, this.fileSystem, this.config);
        StoreType[] stores = (StoreType[])Arrays.stream(StoreType.values()).filter(type -> type != StoreType.META_DATA).toArray(StoreType[]::new);
        migrator.migrate(storeDir, oldFormat, migrationDir, newFormat, stores, new StoreType[0]);
    }

    private void writeLastTxChecksum(File migrationDir, long lastTxChecksum) throws IOException {
        try (Writer writer = this.fileSystem.openAsWriter(StoreMigrator.lastTxChecksumFile(migrationDir), StandardCharsets.UTF_8, false);){
            writer.write(String.valueOf(lastTxChecksum));
        }
    }

    private void writeLastTxLogPosition(File migrationDir, LogPosition lastTxLogPosition) throws IOException {
        try (Writer writer = this.fileSystem.openAsWriter(StoreMigrator.lastTxLogPositionFile(migrationDir), StandardCharsets.UTF_8, false);){
            writer.write(lastTxLogPosition.getLogVersion() + "A" + lastTxLogPosition.getByteOffset());
        }
    }

    static long readLastTxChecksum(FileSystemAbstraction fileSystem, File migrationDir) throws IOException {
        try (Reader reader = fileSystem.openAsReader(StoreMigrator.lastTxChecksumFile(migrationDir), StandardCharsets.UTF_8);){
            char[] buffer = new char[100];
            int chars = reader.read(buffer);
            long l = Long.parseLong(String.valueOf(buffer, 0, chars));
            return l;
        }
    }

    static LogPosition readLastTxLogPosition(FileSystemAbstraction fileSystem, File migrationDir) throws IOException {
        try (Reader reader = fileSystem.openAsReader(StoreMigrator.lastTxLogPositionFile(migrationDir), StandardCharsets.UTF_8);){
            char[] buffer = new char[4096];
            int chars = reader.read(buffer);
            String s = String.valueOf(buffer, 0, chars);
            String[] split = s.split("A");
            LogPosition logPosition = new LogPosition(Long.parseLong(split[0]), Long.parseLong(split[1]));
            return logPosition;
        }
    }

    private static File lastTxChecksumFile(File migrationDir) {
        return new File(migrationDir, "lastxchecksum");
    }

    private static File lastTxLogPositionFile(File migrationDir) {
        return new File(migrationDir, "lastxlogposition");
    }

    private long extractTransactionChecksum(File neoStore, File storeDir, long txId) throws IOException {
        try {
            return MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_TRANSACTION_CHECKSUM);
        }
        catch (IllegalStateException e) {
            try {
                return this.legacyLogs.getTransactionChecksum(storeDir, txId);
            }
            catch (IOException ioe) {
                return txId == 1L ? 0L : Math.abs(new Random().nextLong());
            }
        }
    }

    private LogPosition extractTransactionLogPosition(File neoStore, File storeDir, long lastTxId) throws IOException {
        long lastClosedTxLogVersion = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_VERSION);
        long lastClosedTxLogByteOffset = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET);
        if (lastClosedTxLogVersion != -1L && lastClosedTxLogByteOffset != -1L) {
            return new LogPosition(lastClosedTxLogVersion, lastClosedTxLogByteOffset);
        }
        if (lastTxId == 1L) {
            return new LogPosition(0L, 16L);
        }
        PhysicalLogFiles logFiles = new PhysicalLogFiles(storeDir, this.fileSystem);
        long logVersion = logFiles.getHighestLogVersion();
        if (logVersion == -1L) {
            return new LogPosition(0L, 16L);
        }
        long offset = this.fileSystem.getFileSize(logFiles.getLogFileForVersion(logVersion));
        return new LogPosition(logVersion, offset);
    }

    private void removeDuplicateEntityProperties(File storeDir, File migrationDir, PageCache pageCache, SchemaIndexProvider schemaIndexProvider, RecordFormats oldFormat) throws IOException {
        StoreFile.fileOperation(FileOperation.COPY, this.fileSystem, storeDir, migrationDir, Iterables.iterable((Object[])new StoreFile[]{StoreFile.PROPERTY_STORE, StoreFile.PROPERTY_KEY_TOKEN_NAMES_STORE, StoreFile.PROPERTY_KEY_TOKEN_STORE, StoreFile.PROPERTY_ARRAY_STORE, StoreFile.PROPERTY_STRING_STORE, StoreFile.NODE_STORE, StoreFile.NODE_LABEL_STORE, StoreFile.SCHEMA_STORE}), false, ExistingTargetStrategy.SKIP, StoreFileType.STORE);
        StoreFile.fileOperation(FileOperation.COPY, this.fileSystem, storeDir, migrationDir, Iterables.iterable((Object[])new StoreFile[]{StoreFile.PROPERTY_STORE, StoreFile.PROPERTY_KEY_TOKEN_NAMES_STORE, StoreFile.PROPERTY_KEY_TOKEN_STORE, StoreFile.NODE_STORE}), true, ExistingTargetStrategy.SKIP, StoreFileType.ID);
        StoreFile.removeTrailers(oldFormat.storeVersion(), this.fileSystem, migrationDir, pageCache.pageSize());
        new PropertyDeduplicator(this.fileSystem, migrationDir, pageCache, schemaIndexProvider).deduplicateProperties();
    }

    private void rebuildCountsFromScratch(File storeDir, long lastTxId, PageCache pageCache) {
        File storeFileBase = new File(storeDir, "neostore.counts.db");
        StoreFactory storeFactory = new StoreFactory(this.fileSystem, storeDir, pageCache, (LogProvider)NullLogProvider.getInstance());
        try (NeoStores neoStores = storeFactory.openAllNeoStores();){
            NodeStore nodeStore = neoStores.getNodeStore();
            RelationshipStore relationshipStore = neoStores.getRelationshipStore();
            try (Lifespan life = new Lifespan(new Lifecycle[0]);){
                int highLabelId = (int)neoStores.getLabelTokenStore().getHighId();
                int highRelationshipTypeId = (int)neoStores.getRelationshipTypeTokenStore().getHighId();
                CountsComputer initializer = new CountsComputer(lastTxId, nodeStore, relationshipStore, highLabelId, highRelationshipTypeId);
                life.add((Lifecycle)new CountsTracker(this.logService.getInternalLogProvider(), this.fileSystem, pageCache, this.config, storeFileBase).setInitializer(initializer));
            }
        }
    }

    private void migrateWithBatchImporter(File storeDir, File migrationDir, long lastTxId, long lastTxChecksum, long lastTxLogVersion, long lastTxLogByteOffset, MigrationProgressMonitor.Section progressMonitor, RecordFormats oldFormat, RecordFormats newFormat) throws IOException {
        this.prepareBatchImportMigration(storeDir, migrationDir, oldFormat, newFormat);
        boolean requiresDynamicStoreMigration = !newFormat.dynamic().equals(oldFormat.dynamic());
        boolean requiresPropertyMigration = !newFormat.property().equals(oldFormat.property()) || requiresDynamicStoreMigration;
        File badFile = new File(storeDir, "bad.log");
        try (NeoStores legacyStore = this.instantiateLegacyStore(oldFormat, storeDir);
             BufferedOutputStream badOutput = new BufferedOutputStream(new FileOutputStream(badFile, false));){
            Configuration.Overridden importConfig = new Configuration.Overridden(this.config);
            AdditionalInitialIds additionalInitialIds = this.readAdditionalIds(storeDir, lastTxId, lastTxChecksum, lastTxLogVersion, lastTxLogByteOffset);
            ParallelBatchImporter importer = new ParallelBatchImporter(migrationDir.getAbsoluteFile(), this.fileSystem, importConfig, this.logService, ExecutionSupervisors.withDynamicProcessorAssignment(this.migrationBatchImporterMonitor(legacyStore, progressMonitor, importConfig), importConfig), additionalInitialIds, this.config);
            InputIterable<InputNode> nodes = this.legacyNodesAsInput(legacyStore, requiresPropertyMigration);
            InputIterable<InputRelationship> relationships = this.legacyRelationshipsAsInput(legacyStore, requiresPropertyMigration);
            importer.doImport(Inputs.input(nodes, relationships, IdMappers.actual(), IdGenerators.fromInput(), true, Collectors.badCollector(badOutput, 0)));
            ArrayList<StoreFile> storesToDeleteFromMigratedDirectory = new ArrayList<StoreFile>();
            storesToDeleteFromMigratedDirectory.add(StoreFile.NEO_STORE);
            if (!requiresPropertyMigration) {
                storesToDeleteFromMigratedDirectory.addAll(Arrays.asList(StoreFile.PROPERTY_STORE, StoreFile.PROPERTY_STRING_STORE, StoreFile.PROPERTY_ARRAY_STORE));
            }
            if (!requiresDynamicStoreMigration) {
                storesToDeleteFromMigratedDirectory.addAll(Arrays.asList(StoreFile.NODE_LABEL_STORE, StoreFile.LABEL_TOKEN_STORE, StoreFile.LABEL_TOKEN_NAMES_STORE, StoreFile.RELATIONSHIP_TYPE_TOKEN_STORE, StoreFile.RELATIONSHIP_TYPE_TOKEN_NAMES_STORE, StoreFile.PROPERTY_KEY_TOKEN_STORE, StoreFile.PROPERTY_KEY_TOKEN_NAMES_STORE, StoreFile.SCHEMA_STORE));
            }
            StoreFile.fileOperation(FileOperation.DELETE, this.fileSystem, migrationDir, null, storesToDeleteFromMigratedDirectory, true, null, StoreFileType.values());
        }
        StoreFile.fileOperation(FileOperation.DELETE, this.fileSystem, migrationDir, null, StoreFile.currentStoreFiles(), true, null, StoreFileType.ID);
    }

    private NeoStores instantiateLegacyStore(RecordFormats format, File storeDir) {
        return new StoreFactory(storeDir, this.config, new ReadOnlyIdGeneratorFactory(), this.pageCache, this.fileSystem, (LogProvider)NullLogProvider.getInstance(), format).openAllNeoStores(true);
    }

    private void prepareBatchImportMigration(File storeDir, File migrationDir, RecordFormats oldFormat, RecordFormats newFormat) throws IOException {
        BatchingNeoStores.createStore(this.fileSystem, migrationDir.getPath(), this.config);
        if (newFormat.dynamic().equals(oldFormat.dynamic())) {
            Iterable storeFiles = Iterables.iterable((Object[])new StoreFile[]{StoreFile.NODE_LABEL_STORE});
            StoreFile.fileOperation(FileOperation.COPY, this.fileSystem, storeDir, migrationDir, storeFiles, true, ExistingTargetStrategy.FAIL, StoreFileType.values());
        } else {
            DirectRecordStoreMigrator migrator = new DirectRecordStoreMigrator(this.pageCache, this.fileSystem, this.config);
            migrator.migrate(storeDir, oldFormat, migrationDir, newFormat, new StoreType[]{StoreType.LABEL_TOKEN, StoreType.LABEL_TOKEN_NAME, StoreType.PROPERTY_KEY_TOKEN, StoreType.PROPERTY_KEY_TOKEN_NAME, StoreType.RELATIONSHIP_TYPE_TOKEN, StoreType.RELATIONSHIP_TYPE_TOKEN_NAME, StoreType.NODE_LABEL, StoreType.SCHEMA}, StoreType.NODE);
        }
    }

    private AdditionalInitialIds readAdditionalIds(File storeDir, final long lastTxId, final long lastTxChecksum, final long lastTxLogVersion, final long lastTxLogByteOffset) throws IOException {
        final int propertyKeyTokenHighId = this.readHighIdFromIdFileIfExists(storeDir, ".propertystore.db.index");
        final int labelTokenHighId = this.readHighIdFromIdFileIfExists(storeDir, ".labeltokenstore.db");
        final int relationshipTypeTokenHighId = this.readHighIdFromIdFileIfExists(storeDir, ".relationshiptypestore.db");
        return new AdditionalInitialIds(){

            @Override
            public int highRelationshipTypeTokenId() {
                return relationshipTypeTokenHighId;
            }

            @Override
            public int highPropertyKeyTokenId() {
                return propertyKeyTokenHighId;
            }

            @Override
            public int highLabelTokenId() {
                return labelTokenHighId;
            }

            @Override
            public long lastCommittedTransactionId() {
                return lastTxId;
            }

            @Override
            public long lastCommittedTransactionChecksum() {
                return lastTxChecksum;
            }

            @Override
            public long lastCommittedTransactionLogVersion() {
                return lastTxLogVersion;
            }

            @Override
            public long lastCommittedTransactionLogByteOffset() {
                return lastTxLogByteOffset;
            }
        };
    }

    private int readHighIdFromIdFileIfExists(File storeDir, String storeName) throws IOException {
        String file = StoreFileType.ID.augment(new File(storeDir, "neostore" + storeName).getPath());
        try {
            return (int)IdGeneratorImpl.readHighId(this.fileSystem, new File(file));
        }
        catch (FileNotFoundException e) {
            return 0;
        }
    }

    private ExecutionMonitor migrationBatchImporterMonitor(NeoStores legacyStore, MigrationProgressMonitor.Section progressMonitor, org.neo4j.unsafe.impl.batchimport.Configuration config) {
        return new BatchImporterProgressMonitor(legacyStore.getNodeStore().getHighId(), legacyStore.getRelationshipStore().getHighId(), config, progressMonitor);
    }

    private InputIterable<InputRelationship> legacyRelationshipsAsInput(NeoStores legacyStore, boolean requiresPropertyMigration) {
        RelationshipStore store = legacyStore.getRelationshipStore();
        final BiConsumer propertyDecorator = this.propertyDecorator(requiresPropertyMigration, legacyStore);
        return new StoreScanAsInputIterable<InputRelationship, RelationshipRecord>((RecordStore)store){

            @Override
            protected InputRelationship inputEntityOf(RelationshipRecord record) {
                InputRelationship result = new InputRelationship("legacy store", record.getId(), record.getId() * 34L, InputEntity.NO_PROPERTIES, record.getNextProp(), record.getFirstNode(), record.getSecondNode(), null, record.getType());
                propertyDecorator.accept(result, record);
                result.setSpecificId(record.getId());
                return result;
            }
        };
    }

    private InputIterable<InputNode> legacyNodesAsInput(NeoStores legacyStore, boolean requiresPropertyMigration) {
        NodeStore store = legacyStore.getNodeStore();
        final BiConsumer propertyDecorator = this.propertyDecorator(requiresPropertyMigration, legacyStore);
        return new StoreScanAsInputIterable<InputNode, NodeRecord>((RecordStore)store){

            @Override
            protected InputNode inputEntityOf(NodeRecord record) {
                InputNode node = new InputNode("legacy store", record.getId(), record.getId() * 15L, record.getId(), InputEntity.NO_PROPERTIES, record.getNextProp(), InputNode.NO_LABELS, record.getLabelField());
                propertyDecorator.accept(node, record);
                return node;
            }
        };
    }

    private <ENTITY extends InputEntity, RECORD extends PrimitiveRecord> BiConsumer<ENTITY, RECORD> propertyDecorator(boolean requiresPropertyMigration, NeoStores stores) {
        if (!requiresPropertyMigration) {
            return (a, b) -> {};
        }
        StorePropertyCursor cursor = new StorePropertyCursor(stores.getPropertyStore(), ignored -> {});
        ArrayList scratch = new ArrayList();
        return (entity, record) -> {
            cursor.init(record.getNextProp(), LockService.NO_LOCK);
            scratch.clear();
            while (cursor.next()) {
                scratch.add(cursor.propertyKeyId());
                scratch.add(cursor.value());
            }
            entity.setProperties(scratch.isEmpty() ? InputEntity.NO_PROPERTIES : scratch.toArray());
            cursor.close();
        };
    }

    @Override
    public void moveMigratedFiles(File migrationDir, File storeDir, String versionToUpgradeFrom, String versionToUpgradeTo) throws IOException {
        boolean movingAwayFromVersionTrailers;
        StoreFile.fileOperation(FileOperation.MOVE, this.fileSystem, migrationDir, storeDir, StoreFile.currentStoreFiles(), true, ExistingTargetStrategy.OVERWRITE, StoreFileType.values());
        RecordFormats oldFormat = InternalRecordFormatSelector.fromVersion(versionToUpgradeFrom);
        RecordFormats newFormat = InternalRecordFormatSelector.fromVersion(versionToUpgradeTo);
        boolean bl = movingAwayFromVersionTrailers = oldFormat.hasCapability(Capability.VERSION_TRAILERS) && !newFormat.hasCapability(Capability.VERSION_TRAILERS);
        if (movingAwayFromVersionTrailers) {
            StoreFile.removeTrailers(versionToUpgradeFrom, this.fileSystem, storeDir, this.pageCache.pageSize());
        }
        File neoStore = new File(storeDir, "neostore");
        long logVersion = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LOG_VERSION);
        long lastCommittedTx = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_TRANSACTION_ID);
        this.updateOrAddNeoStoreFieldsAsPartOfMigration(migrationDir, storeDir, versionToUpgradeTo);
        this.legacyLogs.deleteUnusedLogFiles(storeDir);
        if (movingAwayFromVersionTrailers) {
            new StoreMigratorCheckPointer(storeDir, this.fileSystem).checkPoint(logVersion, lastCommittedTx);
        }
    }

    @Override
    public void rebuildCounts(File storeDir, String versionToMigrateFrom) throws IOException {
        switch (versionToMigrateFrom) {
            case "v0.A.3": 
            case "v0.A.5": {
                Iterable countsStoreFiles = Iterables.iterable((Object[])new StoreFile[]{StoreFile.COUNTS_STORE_LEFT, StoreFile.COUNTS_STORE_RIGHT});
                StoreFile.fileOperation(FileOperation.DELETE, this.fileSystem, storeDir, storeDir, countsStoreFiles, true, null, StoreFileType.STORE);
                File neoStore = new File(storeDir, "neostore");
                long lastTxId = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_TRANSACTION_ID);
                this.rebuildCountsFromScratch(storeDir, lastTxId, this.pageCache);
                break;
            }
        }
    }

    private void updateOrAddNeoStoreFieldsAsPartOfMigration(File migrationDir, File storeDir, String versionToMigrateTo) throws IOException {
        File storeDirNeoStore = new File(storeDir, "neostore");
        MetaDataStore.setRecord(this.pageCache, storeDirNeoStore, MetaDataStore.Position.UPGRADE_TRANSACTION_ID, MetaDataStore.getRecord(this.pageCache, storeDirNeoStore, MetaDataStore.Position.LAST_TRANSACTION_ID));
        MetaDataStore.setRecord(this.pageCache, storeDirNeoStore, MetaDataStore.Position.UPGRADE_TIME, System.currentTimeMillis());
        long lastTxChecksum = StoreMigrator.readLastTxChecksum(this.fileSystem, migrationDir);
        MetaDataStore.setRecord(this.pageCache, storeDirNeoStore, MetaDataStore.Position.LAST_TRANSACTION_CHECKSUM, lastTxChecksum);
        MetaDataStore.setRecord(this.pageCache, storeDirNeoStore, MetaDataStore.Position.UPGRADE_TRANSACTION_CHECKSUM, lastTxChecksum);
        LogPosition logPosition = StoreMigrator.readLastTxLogPosition(this.fileSystem, migrationDir);
        MetaDataStore.setRecord(this.pageCache, storeDirNeoStore, MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_VERSION, logPosition.getLogVersion());
        MetaDataStore.setRecord(this.pageCache, storeDirNeoStore, MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET, logPosition.getByteOffset());
        MetaDataStore.setRecord(this.pageCache, storeDirNeoStore, MetaDataStore.Position.STORE_VERSION, MetaDataStore.versionStringToLong(versionToMigrateTo));
    }

    @Override
    public void cleanup(File migrationDir) throws IOException {
        this.fileSystem.deleteRecursively(migrationDir);
    }

    public String toString() {
        return "Kernel StoreMigrator";
    }

    private class BatchImporterProgressMonitor
    extends CoarseBoundedProgressExecutionMonitor {
        private final MigrationProgressMonitor.Section progressMonitor;

        BatchImporterProgressMonitor(long highNodeId, long highRelationshipId, Configuration configuration, MigrationProgressMonitor.Section progressMonitor) {
            super(highNodeId, highRelationshipId, configuration);
            this.progressMonitor = progressMonitor;
            this.progressMonitor.start(this.total());
        }

        @Override
        protected void progress(long progress) {
            this.progressMonitor.progress(progress);
        }
    }
}

