/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.participant;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.format.CapabilityType;
import org.neo4j.kernel.impl.store.format.InternalRecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.storemigration.monitoring.MigrationProgressMonitor;
import org.neo4j.kernel.impl.storemigration.participant.AbstractStoreMigrationParticipant;
import org.neo4j.kernel.spi.legacyindex.IndexImplementation;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.upgrade.lucene.LegacyIndexMigrationException;
import org.neo4j.upgrade.lucene.LuceneLegacyIndexUpgrader;

public class LegacyIndexMigrator
extends AbstractStoreMigrationParticipant {
    private static final String LUCENE_LEGACY_INDEX_PROVIDER_NAME = "lucene";
    private final Map<String, IndexImplementation> indexProviders;
    private final FileSystemAbstraction fileSystem;
    private File migrationLegacyIndexesRoot;
    private File originalLegacyIndexesRoot;
    private final Log log;
    private boolean legacyIndexMigrated = false;

    public LegacyIndexMigrator(FileSystemAbstraction fileSystem, Map<String, IndexImplementation> indexProviders, LogProvider logProvider) {
        super("Legacy indexes");
        this.fileSystem = fileSystem;
        this.indexProviders = indexProviders;
        this.log = logProvider.getLog(this.getClass());
    }

    @Override
    public void migrate(File storeDir, File migrationDir, MigrationProgressMonitor.Section progressMonitor, String versionToMigrateFrom, String versionToMigrateTo) throws IOException {
        IndexImplementation indexImplementation = this.indexProviders.get(LUCENE_LEGACY_INDEX_PROVIDER_NAME);
        if (indexImplementation != null) {
            RecordFormats to;
            RecordFormats from = InternalRecordFormatSelector.fromVersion(versionToMigrateFrom);
            if (!from.hasSameCapabilities(to = InternalRecordFormatSelector.fromVersion(versionToMigrateTo), CapabilityType.INDEX)) {
                this.originalLegacyIndexesRoot = indexImplementation.getIndexImplementationDirectory(storeDir);
                this.migrationLegacyIndexesRoot = indexImplementation.getIndexImplementationDirectory(migrationDir);
                if (this.isNotEmptyDirectory(this.originalLegacyIndexesRoot)) {
                    this.migrateLegacyIndexes(progressMonitor);
                    this.legacyIndexMigrated = true;
                }
            }
        } else {
            this.log.debug("Lucene index provider not found, nothing to migrate.");
        }
    }

    @Override
    public void moveMigratedFiles(File migrationDir, File storeDir, String versionToMigrateFrom, String versionToMigrateTo) throws IOException {
        if (this.legacyIndexMigrated) {
            this.fileSystem.deleteRecursively(this.originalLegacyIndexesRoot);
            this.fileSystem.moveToDirectory(this.migrationLegacyIndexesRoot, this.originalLegacyIndexesRoot.getParentFile());
        }
    }

    @Override
    public void cleanup(File migrationDir) throws IOException {
        if (this.isIndexMigrationDirectoryExists()) {
            this.fileSystem.deleteRecursively(this.migrationLegacyIndexesRoot);
        }
    }

    private boolean isIndexMigrationDirectoryExists() {
        return this.migrationLegacyIndexesRoot != null && this.fileSystem.fileExists(this.migrationLegacyIndexesRoot);
    }

    private void migrateLegacyIndexes(MigrationProgressMonitor.Section progressMonitor) throws IOException {
        try {
            this.fileSystem.copyRecursively(this.originalLegacyIndexesRoot, this.migrationLegacyIndexesRoot);
            Path indexRootPath = this.migrationLegacyIndexesRoot.toPath();
            LuceneLegacyIndexUpgrader indexUpgrader = this.createLuceneLegacyIndexUpgrader(indexRootPath, progressMonitor);
            indexUpgrader.upgradeIndexes();
        }
        catch (LegacyIndexMigrationException lime) {
            this.log.error("Migration of legacy indexes failed. Index: " + lime.getFailedIndexName() + " can't be " + "migrated.", (Throwable)lime);
            throw new IOException("Legacy index migration failed.", lime);
        }
    }

    private boolean isNotEmptyDirectory(File file) {
        if (this.fileSystem.isDirectory(file)) {
            File[] files = this.fileSystem.listFiles(file);
            return files != null && files.length > 0;
        }
        return false;
    }

    LuceneLegacyIndexUpgrader createLuceneLegacyIndexUpgrader(Path indexRootPath, MigrationProgressMonitor.Section progressMonitor) {
        return new LuceneLegacyIndexUpgrader(indexRootPath, this.progressMonitor(progressMonitor));
    }

    private LuceneLegacyIndexUpgrader.Monitor progressMonitor(final MigrationProgressMonitor.Section progressMonitor) {
        return new LuceneLegacyIndexUpgrader.Monitor(){

            public void starting(int total) {
                progressMonitor.start(total);
            }

            public void migrated(String name) {
                progressMonitor.progress(1L);
            }
        };
    }
}

