/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import java.util.function.Predicate;
import org.neo4j.helpers.CloneableInPublic;

public abstract class AbstractBaseRecord
implements CloneableInPublic {
    public static final int NO_ID = -1;
    private long id;
    private long secondaryUnitId;
    private boolean requiresSecondaryUnit;
    private boolean inUse;
    private boolean created;
    private static final Predicate IN_USE_FILTER = new Predicate<AbstractBaseRecord>(){

        @Override
        public boolean test(AbstractBaseRecord item) {
            return item.inUse();
        }
    };
    private static final Predicate NOT_IN_USE_FILTER = new Predicate<AbstractBaseRecord>(){

        @Override
        public boolean test(AbstractBaseRecord item) {
            return !item.inUse();
        }
    };

    protected AbstractBaseRecord(long id) {
        this.id = id;
        this.clear();
    }

    protected AbstractBaseRecord initialize(boolean inUse) {
        this.inUse = inUse;
        this.created = false;
        this.secondaryUnitId = -1L;
        this.requiresSecondaryUnit = false;
        return this;
    }

    public void clear() {
        this.inUse = false;
        this.created = false;
        this.secondaryUnitId = -1L;
        this.requiresSecondaryUnit = false;
    }

    public long getId() {
        return this.id;
    }

    public int getIntId() {
        return Math.toIntExact(this.id);
    }

    public final void setId(long id) {
        this.id = id;
    }

    public void setSecondaryUnitId(long id) {
        this.secondaryUnitId = id;
    }

    public boolean hasSecondaryUnitId() {
        return this.secondaryUnitId != -1L;
    }

    public long getSecondaryUnitId() {
        return this.secondaryUnitId;
    }

    public void setRequiresSecondaryUnit(boolean requires) {
        this.requiresSecondaryUnit = requires;
    }

    public boolean requiresSecondaryUnit() {
        return this.requiresSecondaryUnit;
    }

    public final boolean inUse() {
        return this.inUse;
    }

    public void setInUse(boolean inUse) {
        this.inUse = inUse;
    }

    public final void setCreated() {
        this.created = true;
    }

    public final boolean isCreated() {
        return this.created;
    }

    public int hashCode() {
        return (int)(this.id >>> 32 ^ this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractBaseRecord other = (AbstractBaseRecord)obj;
        return this.id == other.id;
    }

    @Override
    public AbstractBaseRecord clone() {
        throw new UnsupportedOperationException();
    }

    public static <RECORD extends AbstractBaseRecord> Predicate<RECORD> inUseFilter() {
        return IN_USE_FILTER;
    }

    public static <RECORD extends AbstractBaseRecord> Predicate<RECORD> notInUseFilter() {
        return NOT_IN_USE_FILTER;
    }
}

