/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format.lowlimit;

import java.io.IOException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.impl.store.format.BaseOneByteHeaderRecordFormat;
import org.neo4j.kernel.impl.store.format.BaseRecordFormat;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;

public class RelationshipGroupRecordFormat
extends BaseOneByteHeaderRecordFormat<RelationshipGroupRecord> {
    public static final int RECORD_SIZE = 25;

    public RelationshipGroupRecordFormat() {
        super(RelationshipGroupRecordFormat.fixedRecordSize(25), 0, 1);
    }

    @Override
    public void read(RelationshipGroupRecord record, PageCursor cursor, RecordLoad mode, int recordSize, PagedFile storeFile) throws IOException {
        long headerByte = cursor.getByte();
        boolean inUse = this.isInUse((byte)headerByte);
        if (mode.shouldLoad(inUse)) {
            long highByte = cursor.getByte();
            int type = cursor.getShort() & 0xFFFF;
            long nextLowBits = cursor.getUnsignedInt();
            long nextOutLowBits = cursor.getUnsignedInt();
            long nextInLowBits = cursor.getUnsignedInt();
            long nextLoopLowBits = cursor.getUnsignedInt();
            long owningNode = cursor.getUnsignedInt() | (long)cursor.getByte() << 32;
            long nextMod = (headerByte & 0xEL) << 31;
            long nextOutMod = (headerByte & 0x70L) << 28;
            long nextInMod = (highByte & 0xEL) << 31;
            long nextLoopMod = (highByte & 0x70L) << 28;
            record.initialize(inUse, type, BaseRecordFormat.longFromIntAndMod(nextOutLowBits, nextOutMod), BaseRecordFormat.longFromIntAndMod(nextInLowBits, nextInMod), BaseRecordFormat.longFromIntAndMod(nextLoopLowBits, nextLoopMod), owningNode, BaseRecordFormat.longFromIntAndMod(nextLowBits, nextMod));
        }
    }

    @Override
    public void write(RelationshipGroupRecord record, PageCursor cursor, int recordSize, PagedFile storeFile) throws IOException {
        if (record.inUse()) {
            long nextMod = record.getNext() == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? 0L : (record.getNext() & 0x700000000L) >> 31;
            long nextOutMod = record.getFirstOut() == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? 0L : (record.getFirstOut() & 0x700000000L) >> 28;
            long nextInMod = record.getFirstIn() == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? 0L : (record.getFirstIn() & 0x700000000L) >> 31;
            long nextLoopMod = record.getFirstLoop() == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? 0L : (record.getFirstLoop() & 0x700000000L) >> 28;
            cursor.putByte((byte)(nextOutMod | nextMod | 1L));
            cursor.putByte((byte)(nextLoopMod | nextInMod));
            cursor.putShort((short)record.getType());
            cursor.putInt((int)record.getNext());
            cursor.putInt((int)record.getFirstOut());
            cursor.putInt((int)record.getFirstIn());
            cursor.putInt((int)record.getFirstLoop());
            cursor.putInt((int)record.getOwningNode());
            cursor.putByte((byte)(record.getOwningNode() >> 32));
        } else {
            this.markFirstByteAsUnused(cursor);
        }
    }

    @Override
    public RelationshipGroupRecord newRecord() {
        return new RelationshipGroupRecord(-1L);
    }

    @Override
    public long getNextRecordReference(RelationshipGroupRecord record) {
        return record.getNext();
    }
}

